let middle = {"categories":[{"type":"default","name":"Writing Format and Standards","comments":[{"abbreviation":"Heading","comment":"*Revise Heading:*\nType the proper heading in the upper left-hand corner of the first page. The heading consists of the writer's full name; the teacher's title and last name; the class title; and the date.\n*Example:*\nJohn Doe\nMr. Pennington\nEnglish-language Arts−11\n7 March 2021","id":"Heading0.19190226324631476"},{"abbreviation":"Header","comment":"*Revise Header:*\nUsing right-justified text, type the header in the upper right-hand corner beginning on the first page, one-half inch from the top. Include your last name, followed by the page number. Each page must include your last name and page number in the header.\n*Example:* Doe 1","id":"Header0.3735112017234785"},{"abbreviation":"Title","comment":"*Revise Title:*\nUsing center-justified text, type, and capitalize the title. The first letter is capitalized in each word except articles (_a, an,_ or _the_), prepositions (e.g. _from, in, of_), or coordinating conjunctions (FANBOYS: _for, and, nor, but, or, yet, so_) unless it appears as the first word in the title. Do not boldface, italicize, underline, or use quotation marks for the title.\n*Example:* Walking a Mile","id":"Title0.5249980580276572"},{"abbreviation":"Margins","comment":"*Revise Margins:*\nSet one-inch margins for top, bottom, left, and right except the one-half inch header. Use left-justified text and print on white 8.5 x 11-inch paper if a print submission is required.","id":"Margins0.7647943618682627"},{"abbreviation":"Spacing","comment":"*Revise Spacing:*\nSet line spacing to double space for all lines, including the header and title. Single space after all punctuation marks, including periods.","id":"Spacing0.5628442567421577"},{"abbreviation":"Citation","comment":"*Revise Parenthetical (In-Text) Citations Format:*\nIn-text citations identify any outside source of information you use in your writing and must be included on a separate Works Cited page. After the direct or indirect quotation, include the following within parentheses: the author's last name (or title if none listed), followed by a space and the page number (numeral only). If the name of the author or title is used within the quotation, only the page number is included in parentheses. Place a period after the closing parenthesis.\n*Examples:*\nAs the author explains, \"Direct quote\" (Smith 22).\nAccording to Amy Smith, \"Direct quote\" (22).\nThe author argues that...indirect quote (\"Article Title\" 4).\nIn _Canterbury Tales..._ indirect quotation (16).","id":"Citation0.8290765918235035"},{"abbreviation":"Font","comment":"*Change Font:*\nType in a standard, black, size 12 font or as your teacher directs. Use italics for special-use words and titles that don't use quotation marks. Never use all upper case letters in words.","id":"Font0.5926977189155389"},{"abbreviation":"WrksCite","comment":"*Revise Works Cited Format:*\nThe Modern Language Association (MLA) has specific rules for providing full references to parenthetical (in-text) citations. Follow these guidelines.","id":"WrksCite0.7063153941787776"},{"abbreviation":"Inc","comment":"*Incomplete:*\nYou seem to have dissected the writing prompt (assignment) and know what you need to do; however, your work is incomplete. Follow my guidelines to finish and share your best work for me, so I can help you improve your writing.","id":"Inc0.3869821133472393"},{"abbreviation":"Proof","comment":"*Needs Proofreading:*\nYour final draft should be neat and free from writing errors. Make sure to run the spelling check and edit carefully. Read through your final draft out loud to catch any errors.","id":"Proof0.6100558396076536"},{"abbreviation":"Typo","comment":"*Typographical Error:*\nSpelling error due to mistyping. The computer's spellcheck does not catch all typos. Proofread out loud to catch these errors.","id":"Typo0.7171167473594922"},{"abbreviation":"NumErr","comment":"*Number Error:*\nFor numbers zero through nine, write out numbers. For 10 and thereafter, use numbers. Keep the same format, in either written or numerical form, within the same paragraph.","id":"NumErr0.7987848407453002"},{"abbreviation":"Gap","comment":"*Close Gap:*\nThese two words should be combined as a simple compound word or as a hyphenated word. Use hyphens to join words that are necessarily related, but are not compound words. Don't capitalize the letter following the hyphen.","id":"Gap0.05841642111319656"},{"abbreviation":"Para","comment":"*Needs New Paragraph:*\nStart new paragraphs in essays for new ideas, topics, reasons, or arguments. Start new paragraphs in stories for new events, changes in place, changes in time, and for each new speaker in dialogue. Indent one tab for paragraphs. Don't add additional spacing between paragraphs. If your teacher requires block paragraph style, don't indent new paragraphs; instead, add an additional space between paragraphs.","id":"Para0.5453745467030084"},{"abbreviation":"PosForm","comment":"*Positive Format Comment:*\nYou've done an excellent job, making sure that the writing format conforms to Modern Language Association (MLA) standards.","id":"PosForm0.8620342434293089"},{"abbreviation":"PosStnd","comment":"*Positive Standards Comment:*\nYou've done a thorough job, ensuring that your final work is near error-free and up to the standards I've set for all of my students' papers. Thank you for doing your best to meet these standards.","id":"PosStnd0.253450404768782"}],"id":"Writing Format and Standards0.3777619467038418"},{"type":"default","name":"Essay Structure and Content","comments":[{"type":"text","abbreviation":"Intro","comment":"*Revise Introduction:*\nAn essay introduction needs two sentences: a _hook_ and a _summary_ to introduce the thesis statement.\n*▪* The first sentence of your essay is the _hook_. It grabs the attention of your reader. Choose the hook that best matches what the essay is about and your purpose for writing.Try beginning your essay with one of these *QQ SCAR hooks:* Q̲uestion, Q̲uotation, S̲tartling Statement, C̲ontroversial Statement, A̲necdote, or R̲eference to Something Known in Common.\n*Startling Statement Example:* Video games destroy lives.\n*▪* The second sentence of your essay is the _context_. If you are writing about an issue or topic from a reading or video, begin the context sentence with the title and name of the author. Then, tell what the issue or topic is about and provide any necessary background information for your reader. Use another sentence if you need to do so.\n*Context Example:* According to Dr. Phoebe Caulkins, in her article titled, \"The Cost of Gaming,\" American pre-teens and teenagers spend too much time playing games on their desktops, tablets, and phones. Instead of playing outside, gamers are increasingly out of shape and score lower on standardized reading tests.","id":"Intro0.9008369238025205"},{"type":"text","abbreviation":"EvidErr","comment":"*Introducing Evidence Error:*\nDon't introduce evidence in an introduction. You may preview your topic sentences, but don't include *Fact, Example, Statistic, Comparison, Quote from an Authority, Logic, or Experience evidence (FE SCALE)*. Save evidence for the body paragraphs.","id":"EvidErr0.7752371234653959"},{"abbreviation":"Thesis1","comment":"*Revise Argumentative Thesis Statement:*\nYour one or two-sentence thesis statement must answer the key question you develop from the writing prompt (assignment). In an argumentative essay, your thesis statement makes a specific claim about an issue or topic, which you will argue throughout the essay. Write your thesis statement as the last sentence or two of the essay introduction, following the _hook_ and _context_ sentences. Make sure to state the issue or writing topic and use the key words of the writing prompt (assignment). You may choose to preview the body paragraphs by listing key idea words from the topic sentences. Use an appropriate transition word or phrase to introduce the thesis statement.\n*Argumentative Essay Example:* However, the positive outcomes of video gaming far outweigh the negatives. Gamers develop better technological skills, increased attention spans, and superior ability to multi-task than those who do not play.","id":"Thesis10.3516760444903164"},{"abbreviation":"Thesis2","comment":"*Revise Informative/Explanatory Thesis Statement:*\nReview the writing prompt (assignment). Your one or two-sentence thesis statement must answer the key question you develop from the writing prompt (assignment). In an informative/explanatory essay, your thesis statement states the purpose for writing and serves as the controlling idea throughout the essay. Write your thesis statement as the last sentence or two of the essay introduction, following the _hook_ and _context_ sentences. Make sure to state the writing topic and use the key words of the writing prompt (assignment). You may choose to preview the body paragraphs by listing key idea words from the topic sentences. Use an appropriate transition word or phrase to introduce the thesis statement.\n*Informative/Explanatory Essay Example:* Video gaming impacts young people in three ways. Gamers develop technological skills, practice sustained concentration, and learn how to multi-task.","id":"Thesis20.859763771491465"},{"abbreviation":"TooBrd","comment":"*Broaden the Thesis Statement Focus:*\nYour thesis statement focuses too narrowly on its issue or topic. The thesis statement needs to be a bit broader to be able to respond to the demands of the writing prompt (assignment). A good thesis statement is like an umbrella: it must cover the whole subject to be effective.\n*Example:* Facial recognition software can identify a person's nose in a large crowd.\n*Revision:* Facial recognition software can identify people in a large crowd.","id":"TooBrd0.5463780228768038"},{"type":"text","abbreviation":"NotImp","comment":"*Revise Unimportant Thesis Statement:*\nThe thesis statement must state a claim, if an argumentative essay, or a purpose, if an informative/explanatory essay, that is meaningful and has some degree of importance.\n*Unimportant Argumentative Thesis Statement Example:* Blue is the best color.\n*Revision:* Blue is the best color to complement a bright white background.\n*Unimportant Informative/Explanatory Thesis Statement Example:* People in France really enjoy their cheese.\n*Revision:* The French especially enjoy four types of cheeses.","id":"NotImp0.6225485543716955"},{"abbreviation":"Split","comment":"*Correct Split Thesis Statement:*\nDon't write a split (divided) thesis. A split thesis includes two claims in an argumentative essay or two purposes in an informative/explanatory essay. Focus on only one claim or purpose in your thesis statement.","id":"Split0.9781559626141969"},{"type":"text","abbreviation":"Partial","comment":"*Correct Partial Thesis Statement:*\nYour thesis statement responds to only part of the writing prompt (assignment). Re-work the key question you developed from the entire writing prompt (assignment) and revise your thesis statement to be a complete answer to this question.","id":"Partial0.5547567509120286"},{"abbreviation":"OwnRef","comment":"*Eliminate Reference to Your Own Writing:*\nDon't refer to yourself or parts of the essay.\n*Examples:* In this essay... The following paragraphs... I will prove that... The evidence will suggest that... The purpose of this essay... My point of view is that... In my opinion...","id":"OwnRef0.6662382925320118"},{"abbreviation":"RhQuest","comment":"*Eliminate the Rhetorical Question:*\nAvoid rhetorical questions in essays. A rhetorical question is a question needing no response because the answer is in the question itself.\n*Example:* Does anyone really think high speed rail is practical?\n*Revision:* High speed rail is impractical for three key reasons.","id":"RhQuest0.5764250415861298"},{"abbreviation":"TopSent","comment":"*Needs Topic Sentence:*\nWrite a topic sentence as the first sentence of each body paragraph unless you have a reason to place it elsewhere. It usually begins with a transition word or phrase and states the main idea of the paragraph. Each topic sentence must directly respond to the thesis statement. In an argumentative essay, each topic sentence states an argument or reason. In an informative/explanatory essay, each topic sentence states a key point or a fact.\n*Example:* First, young people who play video games learn technological skills.","id":"TopSent0.0793458434311427"},{"type":"text","abbreviation":"Detail","comment":"*Needs Concrete Detail:*\nUse specific evidence from credible (believable) experts to support your topic sentences. Choose the types of evidence that will best support your topic sentences with a variety of *FE SCALE Evidence Strategies:* F̲act, E̲xample, S̲tatistic, C̲omparison, Quote from an A̲uthority, L̲ogic, or E̲xperience. In argumentative essays, be careful not to use unsupported opinions. In informative/explanatory essays, use accurate and relevant (that which directly applies) information. Use an evidence sentence starter, which includes a transition word or phrase and the source to introduce the evidence.\n*Quote from an Authority Example:* Even the author admits that gamers are \"... twice as likely as non-gamers to develop some programming ability\" (Lee 3).","id":"Detail0.32843253939962436"},{"abbreviation":"Cite","comment":"*Needs Citation:*\nThis evidence reflects facts or information from an outside source. You need to cite your source for this section and include the citation in your Works Cited page.\n*Examples:*\nAs the author explains, \"Direct quote\" (Smith 22).\nAccording to Amy Smith, \"Direct quote\" (22).\nThe author argues that...indirect quote (\"Article Title\" 4).\nIn _Canterbury Tales..._ indirect quotation (16).","id":"Cite0.19967442161914417"},{"abbreviation":"Comment","comment":"*Needs Commentary:*\nProvide your own comments about the concrete detail. In an argumentative essay, offer your opinion or insight, analyze (examine in parts), or evaluate. In an informative/explanatory essay, interpret, explain, analyze (examine in parts), or provide a definition. Commentary does not add additional details or information. Use an appropriate transition word or phrase to introduce commentary sentences.\n*Example:* As a result, gamers learn how to optimize their games with modifications.","id":"Comment0.7799249443358003"},{"abbreviation":"CRPara","comment":"*Needs Counterargument and Refutation Paragraph:*\nInclude a counterargument and refutation in the last paragraph before the conclusion in an argumentative essay. Begin with a transition word or phrase which signals the opposing point of view, and complete a topic sentence, which state an opposing argument against your claim. Use concrete details to provide the best evidence for the opposing argument. Respond with concrete details and/or commentary sentences to refute (disprove) these arguments. Make sure to include clear transition words or phrases to indicate the shifts in point of view.\n*Counterargument Example:* In contrast, opponents argue that technological skills remain less important than traditional reading and math skills.\n*Refutation Example:* However, studies have demonstrated that technological skills learned by video gaming significantly improve higher level reading and math abilities (Jones 22). Clearly, both technological and academic skills are important to learn.","id":"CRPara0.3712216223301439"},{"abbreviation":"CREmbd","comment":"*Needs Embedded Counterargument and Refutation:*\nEmbed (place within) a counterargument and refutation within the last concrete detail and commentary of each body paragraph. Begin the concrete detail with a transition word or phrase which signals the opposing point of view, and provide evidence which counters the argument presented in your topic sentence (the counterargument). Respond with a concrete detail and commentary sentence or two to refute disprove the argument (refutation).\n*Counterargument Example:* In contrast, opponents argue that video gaming decreases the attention spans of gamers, because other activities, such as schoolwork, cannot constantly stimulate learners in the same manner as video games.\n*Refutation Example:* However, in a recent survey, 75% of avid gamers report a longer attention span than those who do not play video games frequently (Jones 23). Clearly, both technological and academic skills are important to learn.","id":"CREmbd0.014649582737713551"},{"abbreviation":"ConSt","comment":"*Needs Concluding Statement:*\nA concluding statement provides a summary about the body paragraph and does not add new evidence or information. It may include a transition word to connect to the next body paragraph.\n*Example:* As a result, playing video games improves the technological skills of gamers and provides another key benefit.\nNot every body paragraph requires a concluding statement. However, the concluding statement can be useful to re-state the main idea expressed in the topic sentence or emphasize its importance. Use an appropriate transition word or phrase to introduce the concluding statement.","id":"ConSt0.2496055826458896"},{"abbreviation":"ThRest","comment":"*Needs Thesis Restatement:*\nBegin the concluding paragraph of your essay with a thesis restatement. This sentence paraphrases the thesis to remind the reader about the focus of the essay.","id":"ThRest0.9782672851753373"},{"type":"text","abbreviation":"Conclsn","comment":"*Revise Conclusion:*\nThe conclusion comments on the evidence presented in the body paragraphs to satisfy the reader that the thesis statement has been proved (in an argumentative essay) or its purpose achieved (in an informative/explanatory essay). Choose the conclusion strategies which best comment on the concrete details and commentary of your body paragraphs with a variety of the *GQ SALES Conclusion Strategies:* G̲eneralization, Q̲uestion for Further Study, Statement of S̲ignificance, A̲pplication, L̲imitations, E̲mphasis of Key Point, S̲ummary Statement, or for the argumentative essay, a C̲all to Action. Use an appropriate transition word or phrase to introduce the conclusion comments.\n*Application* *Example:* Moreover, video gaming has further benefits beyond the development of technological skills. Gamers develop teamwork skills, which are becoming increasingly helpful in the school and in the workplace. Indeed, video gaming can be purposeful play.","id":"Conclsn0.7564247866047518"},{"abbreviation":"PosEStr","comment":"*Positive Essay Structure Comment:*\nYour writing has demonstrated an excellent understanding about how an essay should be structured with a hook, summary, and thesis statement in the introduction; body paragraphs with topic sentences, concrete details, commentary, and concluding statements; and a conclusion paragraph with thesis restatement and conclusion strategies.","id":"PosEStr0.1304968719534001"},{"abbreviation":"PosECon","comment":"*Positive Essay Content Comment:*\nYour skillful use of research and information to prepare this essay is impressive. You have used resources from experts on the subject of your writing, and you have also added creative and original thinking in this essay.","id":"PosECon0.7210572177326986"}],"id":"Essay Structure and Content0.4574956788315452"},{"type":"default","name":"Narrative Structure and Content","comments":[{"abbreviation":"Lead","comment":"*Revise Narrative Lead:*\nThe first sentence or two of your story should _hook_ your reader's interest. In a story or article, the _hook_ is also called a _lead._ The lead introduces the _exposition_ (or _basic situation_), which also introduces the main characters, setting, and any essential background information. For short stories, try using one of these leads to begin your story:\n*▪* A *dialogue lead* begins the story with short, but interesting, exciting, or suspenseful spoken remarks or a conversation between two of the story characters.\n*Example:* \"Did you see that?\" screamed my brother. \"It just about took off my head. Quick, let's get under cover before it comes back!\"\n*▪* An *action lead* begins the story with the main character or characters involved in some kind of exciting, suspenseful, adventurous, or surprising activity.\n*Example:* Whoosh! the parachute opens and the straps tug violently at my shoulders.\n*▪* A *sensory lead* begins the story with vivid sensory images.\n*Example:* The snow crunched under my boots, and the wind whistled mercilessly through the bending and snapping pine trees. A faint smell of smoke kept me walking down the mountain.\nAfter the lead, introduce the main character or characters, setting, and any other information that your reader needs to understand your story. This beginning section of your story, including the lead, character introduction, setting, and background is called the _exposition_ (or _basic situation_).","id":"Lead0.943411050741856"},{"abbreviation":"CharInt","comment":"*Needs Character Introduction:*\nNeeds a more detailed character description to introduce your main character or characters. _Tell_ or _show_ the _character traits_ (what makes each person unique) that will best define your character's personality, relationships to other characters, and role in the story. Following are types of character roles found in many narratives:\n*▪* The _protagonist_ is the main character who is involved in the primary conflict. Usually, the protagonist is the hero of the story.\n*▪* The _antagonist_ is the character who opposes the protagonist in the conflict. The antagonist may act as the villain or _bad guy_ in the story.\n*▪* Minor characters appear less often in the story. However, minor characters can influence the plot and other characters.","id":"CharInt0.3418924304984796"},{"abbreviation":"Setting","comment":"*Revise Setting:*\nNeeds more specific setting details. The setting is the time and place of the story. It may include the historical and cultural context for the characters and plot.\n*Setting Example:* The factory whistle blew for quitting time: five o'clock, and not a minute too soon on this cloudy January day, far from the cheer of Christmas. The year was 1938. My hometown of Akron, Ohio, was no different than any other colorless midwestern town.","id":"Setting0.2875192089116543"},{"abbreviation":"Conflct","comment":"*Clarify Conflict:*\nThe conflict is unclear. The conflict is the key problem that the characters face in the plot. The conflict may be _external_ (outside the characters) or _internal_ (inside the characters).\n*External Conflict Examples:* character vs. character, character vs. nature, character vs. technology, character vs. society\n*Internal Conflict Examples:* character vs. emotions, character vs. needs or desires, character vs. temptations, character vs. the past. Stories may have both primary and secondary conflicts.","id":"Conflct0.01681197915125532"},{"abbreviation":"POV","comment":"*Inconsistent Point of View:*\nThe point of view is inconsistent. The point of view refers to how the story is told. Most authors use one of these points of view to tell the story:\n*▪* First Person: One of the characters tells the story using I. The reader only knows what the character knows and senses.\n*Example:* I walked into the hallway, not knowing where it would lead.\n*▪* Third Person Limited: The narrator, who is not involved in the story, tells the reader what one main character knows and senses.\n*Example:* Marsha and Brad left the house together. Marta wondered if they would return.\n*▪* Third Person Omniscient: The narrator or character telling the story knows and senses everything about the characters' past, present, and future. _Omniscient_ means _all-knowing._\n*Example:* The children did not know that the zombies were waiting for them at the end of the tunnel.","id":"POV0.1858059625516102"},{"abbreviation":"RisAct","comment":"*Needs More Rising Action:*\nNeeds more plot development before the story climax. Rising action is the series of events that develop the characters and the conflict to prepare the reader for the story climax.","id":"RisAct0.6738500033321351"},{"abbreviation":"Climax","comment":"*Revise Climax:*\nNeeds a more detailed climax. The climax is the most exciting part of the story. It is also the turning point of the story in which the interaction of the characters dealing with the primary conflict is at the highest point of interest, intensity, or suspense. The climax is usually included toward the end of the story.","id":"Climax0.5921042061053203"},{"abbreviation":"FallAct","comment":"*Needs More Falling Action:*\nThe falling action serves as a transition between the climax and the resolution. Your resolution follows too soon after the climax. More falling action details are needed to tie up loose ends with the plot and characters and to settle the reader following the intensity of the climax.","id":"FallAct0.06186738087101329"},{"abbreviation":"Resltn","comment":"*Clarify Resolution:*\nNeeds a more detailed and clear resolution. The resolution follows the falling action and resolves the key conflict or conflicts of the story. It provides a satisfying ending in which the reader discovers what happens to the main characters and how the plot draws to a close.","id":"Resltn0.11721080833266773"},{"abbreviation":"CharDev","comment":"*Needs More Character Development:*\nNeeds more detailed and specific character development. Use the *STEAL Characterization Strategy* to create interesting characters*: Speech* (how and what the characters say in dialogue); *Thought* (what the characters think); *Effect* on others (how the characters relate to one another); *Action* (what the characters do and the how they respond to the consequences of their actions); and *Looks* (the appearance of the characters).\nReveal the _character traits_ (what makes each person unique) through both _direct_ and _indirect_ characterization:\n_Direct_ characterization _tells_ the reader about the character traits through description.\n*Example:* Mr. Tang was patient and focused on the present.\n_Indirect_ characterization _shows_ the character traits through the plot, dialogue, action, and other characters.\n*Example:* His tie was perfectly placed, not too short and not too long.","id":"CharDev0.25827304450134503"},{"abbreviation":"NotChar","comment":"*Inconsistent Characterization:*\nThis doesn't seem to fit your character. Don't surprise or confuse your reader with speech or action that seems _out of character._ Keep consistent with the characterizations which you have already established:\n*▪* A _dynamic_ character changes significantly throughout the narrative. Also referred to as a round character, the character is complex with multiple traits and learns and grows throughout the story.\n*▪* A _static_ character remains the same throughout the narrative.","id":"NotChar0.7747898820219241"},{"abbreviation":"Dialog","comment":"*Revise Dialogue:*\nUse these techniques to write interesting dialogue:\n*▪* Keep speeches short. Don't waste words or tell what the reader already knows.\n*▪* Good dialogue adds to the plot and can suggest action.\n*▪* Use authentic vocabulary and write the way your characters speak. Each character should have a consistent and unique voice, that is, their own way of saying things. Use more idiomatic expressions and slang in dialogue than you use to tell the story.\n*▪* Use a variety of speaker tags (other than _said_),and use them only when needed to show the reader whom is speaking.\n*▪* Don't overuse character names in dialogue.\n*▪* Don't use too much \"thinking\" dialogue.\n*▪* _Show_ the characters' character traits in their speech.\n*▪* Use some intentional fragments and contractions. We don't always speak in complete sentences.","id":"Dialog0.7392838266814148"},{"abbreviation":"Dscrptn","comment":"*Revise Description:*\nGood description uses _show me_, not _tell me_ writing. Use these techniques to write effective description:\n*▪* Description should be specific.\n*Example:* She walked down the stairs into the street.\n*Revision:* She walked down the wooden stairs into Laredo Street.\n*▪* Description should include a variety of the senses (taste, touch, sound, sight, feeling).\n*Example:* The smell of oven-baked cookies and the sounds of an old jazz song welcomed him into the sun-filled room.\n*▪* Description should clearly indicate changes in location.\n*Example:* Tasha changed direction, turning onto the one-way street.","id":"Dscrptn0.3733210733786383"},{"abbreviation":"PlotTch","comment":"*Add Plot Technique:*\nConsider revising this section by adding a specific plot technique to engage your reader. The plot is the sequence of events that happen throughout a story. Certain writing techniques are used to enhance the interest of the plot:\n*▪* A _twist_ provides an unexpected or surprise ending. The conflict is resolved differently than the reader expects.\n*Example:* Tom Sawyer appears at his own funeral.\n*▪* A flashback interrupts the events of the plot to refer back to a past event, which is experienced by the characters as if in the present.\n*Example:* \"I remember the day of our wedding. I am dressed in a pastel blue tuxedo, waiting for my young bride to walk down the aisle.\"\n*▪* _Foreshadowing_ provides the reader hints or clues about something that will happen later in the story.\n*Example:* I opened the drawer and a hunting knife was hidden within the socks.\n*▪* _Symbolism_ is the use of concrete and specific people, places, or things as symbols to represent abstract ideas. The symbols are usually related to the theme of the story.\n*Examples:* A golden apple, a blood-red sun, the north star\n*▪* A motif is a repeated image, pattern, event, or idea that provides clues to understanding the theme.\n*Examples:* a bell ringing at key points in the story, a repeated number 7 when something good happens","id":"PlotTch0.9662128787195414"},{"abbreviation":"FigLng","comment":"*Clarify Figurative Language:*\nRevise the figurative language or substitute with literal language. Figurative language appeals to the senses of the reader by using non-literal figures of speech.\n*Examples:* simile, metaphor, personification, allusion, irony, imagery","id":"FigLng0.5536608870400985"},{"abbreviation":"ToneMood","comment":"*Inconsistent Tone and Mood:*\nThe tone of this section and the mood it creates don't fit with the rest of the story. The tone is the author's attitude or feelings about the characters, the plot, and the reader. The mood is how the reader feels in response to the tone. The tone and mood are shaped by word choice, figurative language, and how sentences are constructed to tell the story.\n*Examples of Tone:* positive, negative, sarcastic, humorous, optimistic, pessimistic, serious, reverent.\n*Examples of Mood:* enlightening, sympathetic, trusting, stressful, angry, relieved, convinced, nostalgic","id":"ToneMood0.9079941001681537"},{"abbreviation":"Theme","comment":"*Clarify Theme:*\nThe thematic subject and/or the theme needs further development. Short stories, like novels, include a theme. The thematic subject is the main idea which the author focuses upon in the text. Short stories, like novels, include a theme.\n*Examples:* lost love, growing up, facing adversity\nThe theme is the message or lesson about life that the author communicates to the reader about the thematic subject. The theme is usually implied (not stated) and is universal (applying to everyone). An author may share more than one theme.\n*Examples:* Everyone needs love. Seemingly good people have the capacity for evil.","id":"Theme0.04625695110321293"},{"abbreviation":"PosNStr","comment":"*Positive Narrative Structure Comment:*\nYou have demonstrated an excellent understanding of how to write the exposition (basic situation) with a narrative lead, main character introductions, setting, and the primary conflict. You know how to structure a narrative plot with the rising action, the climax, the falling action, and a satisfying resolution that solves the conflict.","id":"PosNStr0.5556438479614978"},{"abbreviation":"PosNCon","comment":"*Positive Narrative Content Comment:*\nYour characters are realistic, their roles in the story are clear, and their character traits are well-described. The plot is interesting and entertaining. I so enjoyed your original and creative story.","id":"PosNCon0.9000915752366585"}],"id":"Narrative Structure and Content0.21038182645283876"},{"type":"default","name":"Sentence Formation and Writing Style","comments":[{"abbreviation":"Frag","comment":"*Revise Sentence Fragment:*\nThis sentence fragment is only part of a complete sentence.To fix a sentence fragment, try these revision strategies:\n*▪* Change the fragment into a complete thought by adding a subject or predicate. The subject of a sentence is the \"do-er.\" The predicate is what the \"do-er\" does.\n*Fragment Example:* Solved a problem with her quick thinking.\n*Revision:* _She_ (subject) solved a problem with her quick thinking.\n*Fragment Example:* Mainly the lack of time.\n*Revision:* Mainly, they _needed_ (predicate) more time.\n*▪* Connect the fragment to the sentence before or after.\n*Fragment Example:* Because of the ice. The roads were hazardous.\n*Revision:* The roads were a hazardous because of the ice.\n*▪* Read the sentence out loud. Unless it is a question, the voice naturally drops down at the end of a complete sentence.","id":"Frag0.0711395887392221"},{"abbreviation":"Run-on","comment":"*Revise Sentence Run-on:*\nThis run-on connects two independent clauses (nouns and connected verbs which express complete thoughts) incorrectly. If connected with a comma, the run-on is known as a _comma splice._ To fix a sentence run-on, try these revision strategies:\n*▪* Separate the run-on into two sentences.\n*Run-on Example:* Lou told his mom he told his sister.\n*Revision:* Lou told his mom. He told his sister.\n*▪* Add a comma-conjunction between the clauses.\n*Run-on Example:* Lou told his mom he told his sister.\n*Revision:* Lou told his mom, and he told his sister.\n*▪* Add a semicolon between the clauses if the clauses are directly related.\n*Run-on Example:* Lou told his mom, she was the last to know.\n*Revision:* Lou told his mom; she was the last to know.","id":"Run-on0.6574286602769874"},{"type":"text","abbreviation":"Compnd","comment":"*Combine into Compound Sentence:*\nCombine these short sentences into a compound sentence. A compound sentence has two or more independent clauses (nouns and connected verbs which express complete thoughts), joined by a comma-conjunction or a semicolon. Compound sentences help clarify the relationship between independent clauses.\n*Example:* I like the way she talks. She likes my voice.\n*Revision*: I like the way she talks, and she likes my voice. Avoid placing two compound sentences next to each other in the same paragraph.","id":"Compnd0.818152477515748"},{"type":"text","abbreviation":"Complex","comment":"*Combine into Complex Sentence:*\nCombine these short sentences into a complex sentence. A complex sentence has both an independent clause and a dependent clause. An independent clause has a noun and a connected verb which expresses a complete thought; a dependent clause begins with a subordinating conjunction and has a noun and a connected verb which does not express a complete thought. For sentence variety, place the dependent clause at the beginning, in the middle, and at the end of sentences. \n*AAAWWUBBIS Memory Trick* *(to remember the subordinating conjunctions):* Most dependent clauses begin with these words: _After,_ _Although,_ _As,_ _When,_ _While,_ _Until,_ _Because,_ _Before,_ _If,_ or _Since_.\n*Example:* I finally left my home. After, I cried for days.\n*Revision:* When I finally left home, I cried for days.Avoid placing two complex sentences next to each other in the same paragraph.","id":"Complex0.8424026587031328"},{"abbreviation":"ComCmpx","comment":"*Combine into Compound-Complex Sentence:*\nCombine these sentences into a compound-complex sentence. A compound-complex sentence has two or more independent clauses clauses (nouns and connected verbs which express complete thoughts) and at least one dependent clause (a noun and a connected verb that does not express a complete thought).\n*Example:* After he ate lunch (dependent clause), Tam finished his chores (independent clause), and he took a nap (independent clause). Avoid using more than one compound-complex sentence in any paragraph.","id":"ComCmpx0.6661037160698111"},{"type":"text","abbreviation":"SentVar","comment":"*Needs Sentence Variety:*\nVary the types of sentence structures you use to keep your reader interested. Revising sentences with different grammatical sentence openers improves sentence variety. As a general guideline, no more than 60% of sentences should be constructed in the subject-verb-object sentence pattern.\n*Example:* They (subject) eat (verb) too many hamburgers (object).\n*Revisions:*\n*▪ Adjective* − _Too many_ hamburgers they eat.\nAn adjective modifies (describes, identifies, defines, or limits) a noun and answers Which one? How many? or What kind?\n*▪ Adverb* − _Often_, they eat too many hamburgers.\nAn adverb modifies (describes, identifies, defines, or limits) a verb and answers How? When? Where? or What Degree?\n*▪ Prepositional phrase* − _At home_ they eat too many hamburgers.\nA preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*▪ Participle or Participial Phrase* − _Starved, Starving_, they eat too many hamburgers.\n*▪ Gerund Phrase* − _Eating too many hamburgers_ is unhealthy.\nAvoid writing more than two of the same sentence patterns back-to-back unless you have a specific purpose for doing so.","id":"SentVar0.5505071352635169"},{"type":"text","abbreviation":"ParlStr","comment":"*Needs Parallel Structure:*\nRepeat grammatical structures in sentences and paragraphs to create a writing rhythm. Pay special attention to these sentence components to create parallelism.\n*▪* Verb forms\n*Example:* We cannot hope to dedicate... We can't consecrate... and hallowing the ground we cannot do.\n*Revision:* We cannot dedicate... We cannot consecrate... We cannot hallow this ground (Lincoln's \"Gettysburg Address\").\n*▪* Noun phrase constructions\n*Example:* We studied the French, Spanish, people from England, and those Portuguese\n*Revision:* We studied the French, the Spanish, the English, and the Portuguese.\n*▪* Gerunds (verb forms which act as nouns)\n*Example:* To run a marathon, climb Mt. Shasta, and a mile swim are on my bucket list.\n*Revision:* Running a marathon, climbing Mt. Shasta, and swimming a mile are on my bucket list.\n*▪* Coordinating conjunctions\n*Example:*\nSmoking can result in lung disease or even be deadly.\n*Revision:*\nSmoking can result _in lung disease_ or even _in death_.","id":"ParlStr0.16354096667428997"},{"type":"text","abbreviation":"Chron","comment":"*Rearrange in* *Chronological Order:*\n_Chronological_ refers to the order of time, from older events to newer ones. Use transition words such as _first_, _second_, _later_, _next_, _before_, _for one_, _for another_, _previously_, _then_, _finally_, _following_, _since_, and _now_ to establish a time sequence from old to new.\n*Example:* Mary asked if she could go with us, later she got permission from her parents, but before both she had cancelled her plans.\n*Revision:* First, Mary cancelled her plans. Then she asked if she could go with us. Later, she got permission from her parents.","id":"Chron0.9542680166075654"},{"type":"text","abbreviation":"Interpt","comment":"*Eliminate Sentence Interruption:*\nSentence interruptions can ruin the flow of a sentence. Awkward or distracting interruptions reduce the reader's understanding of what you mean to say. Rearrange the sentence or simply delete the interruptions.\n*Examples:* This was not a good idea, although I must admit I didn't have any better ones, and it was bound to fail.\n*Revision:* This was not a good idea and it was bound to fail, although I must admit I didn't have any better ones.","id":"Interpt0.4493555643705567"},{"abbreviation":"OffTop","comment":"*Off Topic:*\nThe focus of this section does not support the thesis statement. Consider eliminating this section, revising to better demonstrate how it provides support, or substituting with something more relevant (that which directly applies).\n*Example:* Baseball has been called a \"simple game\"; however, it does require skilled decision-making. Hot dogs always taste best at the ballpark (Off Topic).","id":"OffTop0.5185174960639376"},{"abbreviation":"Connect","comment":"*Clarify Connection:*\nHow does this fit with other sections? Consider adding transitions or repeat wording to show relationships. Common relationships include cause and effect, comparison and contrast, and problem to solution.","id":"Connect0.13532886890235596"},{"abbreviation":"Place","comment":"*Out of Place:*\nThis section seems out of place. Consider rearranging sentences or paragraphs to maintain the focus of your reader and unify your writing.","id":"Place0.9493201175347252"},{"abbreviation":"NotClr","comment":"*Not Clear:*\nThis section is confusing and does not seem to fit with the rest. Provide an example, a definition, a comparison or contrast, or more explanation to make it more understandable.\n*Example:* Many still farmed vegetable crops which were in over-supply.\n*Revision:* Many farmers continued to grow vegetables, such as corn, when too much corn was already on the shelves of supermarkets.","id":"NotClr0.31392961833549937"},{"abbreviation":"Awk","comment":"*Awkward:*\nThe construction of this sentence makes it hard to follow. Consider revising the word order or eliminating phrases and clauses which create distance between the subject (the \"do-er\" of the sentence) and predicate (the main verb).\n*Example:* The call, made by the police, to carry out the proposed solution to the problem, was not carried out majority members of the community.\n*Revision:* Most people in the community did not do what the police suggested to solve the problem.","id":"Awk0.7617786379281086"},{"abbreviation":"Trans","comment":"*Needs Transition:*\nUse a transition word or phrase help the reader understand the connection between or shift from one thought to another. Transitions may be placed at the beginning, middle, or end of sentences.\n*Examples:* _First_, she had practiced; however, she practiced incorrectly and _so_ was unsuccessful _for these reasons_.","id":"Trans0.9959794793514227"},{"abbreviation":"Redncy","comment":"*Redundancy:*\nThis section repeats an argument, information, ideas, or explanation already used in the essay or provides _too much of the same_. Often, a writer unnecessarily repeats too many examples, comparisons, facts, or explanations when one or two provides adequate support.\n*Example:* The grocer arranged the green vegetables, such as peas, beans, kale, and peppers, where the shoppers could see them in a display case.\n*Revision:* The grocer arranged the green vegetables, such as peas and beans, in a display case.","id":"Redncy0.40799574066676625"},{"type":"text","abbreviation":"GetSpf","comment":"*Get Specific:*\nThe concrete detail is too general. Substitute with more specific evidence or details to convince, inform, or explain. Choose among these types of evidence: F̲act, E̲xample, S̲tatistic, C̲omparison, Quote from an A̲uthority, L̲ogic, or E̲xperience *(FE SCALE)*.\n*Example:* Many people visit recreational areas.\n*Revision:* Close to 85% of Americans visited recreational areas, such as parks, beaches, and national forests this year (Matthews 34).","id":"GetSpf0.07520920307848744"},{"abbreviation":"NotCons","comment":"*Not Consistent:*\nThe content or tone of the argument or information has changed, is contradictory, or has been taken in a different direction than what has been said before. Revise to maintain consistent support of your thesis statement.\n*Example:* The math teacher was highly educated, yet she did not know much math.","id":"NotCons0.4967192430526821"},{"abbreviation":"Omission","comment":"*Omission:*\nIt seems that a word, key idea, information, or explanation is missing here. Re-read what you have written from the reader's point of view to to see what needs to be added.\n*Example:* The Folsom High School Band has the best band in the city.\n*Revision:* The Folsom High School Band has the only band in the city, but it is excellent.","id":"Omission0.12250130772758738"},{"abbreviation":"NotCorr","comment":"*Not Correct:*\nThis fact does not seem to be correct, or you have misapplied the evidence. Check your sources and revise as needed.\n*Example:* The earth is a sphere and completely flat.","id":"NotCorr0.39073741643311766"},{"abbreviation":"Seq","comment":"*Sequence Issue:*\nThis sentence is improperly placed and is confusing to the reader. Re-read the paragraph to determine proper placement and revise or delete if it does not fit in to the order or flow of the paragraph.\n*Examples of Proper Sequence:* General to specific, first to last, cause to effect, problem to solution, old to new.","id":"Seq0.9698038711763697"},{"abbreviation":"Overst","comment":"*Overstatement:*\nYour analysis or conclusion goes beyond the evidence that you present. It seems exaggerated in order to prove your point. Commentary which limits the scope of interpretation, explanation, analysis, or evaluation is generally more convincing to your reader.\n*Example:* Everyone was completely shocked to hear the worst news ever.\n*Revision:* Many were shocked to hear the bad news.","id":"Overst0.49221454666216014"},{"abbreviation":"PosSFrm","comment":"*Positive Sentence Formation Comment:*\nYou have crafted your sentences with care. Not all writers have the abilities to make their sentences interesting while following the rules of grammar and writing. Good job! You provide a variety of types of sentences and different grammatical sentence openers, which make reading your writing a pleasure.","id":"PosSFrm0.5588355107671525"},{"abbreviation":"PosWrSt","comment":"*Positive Writing Style Comment:*\nYou demonstrate that you know the purpose of the writing prompt (assignment) and the needs of your reader. Your writing style make your paper easy to read and understand. Sentences are in proper order and nicely transition from one to another.","id":"PosWrSt0.03530561552847544"}],"id":"Sentence Formation and Writing Style0.9211526529440379"},{"type":"default","name":"Word Choice","comments":[{"abbreviation":"UnExpr","comment":"*Delete Unnecessary Expressions:*\nDelete words, phrases, and clauses that do not add meaning.\n*Examples:* I think, I believe, In my opinion, from this writer's point of view, at the end of the day, when all is said and done, in light of these facts","id":"UnExpr0.11616119257599355"},{"type":"text","abbreviation":"DbNeg","comment":"*Revise Double Negative:*\nDon't use double negatives to indicate a positive in formal essays or research papers.\n*Examples:* You should _not_ _fail_ to use soap to wash dishes. Don't not do that ever.\n*Revision:* Always use soap to wash dishes.","id":"DbNeg0.30550276612210703"},{"type":"text","abbreviation":"Wordy","comment":"*Eliminate Wordiness:*\nThis section is longer than it needs to be. Consider deleting words, phrases, or clauses which interrupt the flow of your ideas, or consider re-wording − especially with stronger verbs and more specific nouns. Often, using clauses beginning with _who, whom, which,_ and _that_ and too many prepositional phrases create wordiness.\n*Example:* The girl, whom I used to consider as a friend, but left me to eat lunch alone, which was extremely mean in the cafeteria during lunch on Tuesday ignored me.\n*Revision:* The mean girl ignored me in the cafeteria last Tuesday.","id":"Wordy0.1881740557252385"},{"abbreviation":"To-beVb","comment":"*Revise Too Many \"to be\" Verbs:*\nLimit using so many \"to be\" verbs: _is, am, are, was, were, be, being, been_. To replace \"to be\" verbs: 1. *Substitute* a more active verb. 2. *Convert* one of the words in the sentence to a verb form. 3. *Change* the beginning of the sentence. 4. *Combine* the sentence which has the \"to be\" verb with the sentence before or after to use another stronger and specific verb.\n*Substitute Example:* The child _was_ sad.\n*Revision:* The child _felt_ sad.\n*Convert Example:* Charles Schulz _was_ the _creator_ of the _Peanuts_ cartoon strip.\n*Revision:* Charles Schulz _created_ the _Peanuts_ cartoon strip.\n*Change Example:* The run-away car _will be_ stopped by the tire spikes.\n*Revision:* The tire spikes will stop the run-away car.\n*Combine Example:* The sensitive child _is_ terrified. She _is_ feeling that way because of the news story.\n*Revision:* The news story terrified the sensitive child.","id":"To-beVb0.4886794104302661"},{"abbreviation":"WC","comment":"*Change Word Choice:*\nThis word choice is incorrect, unclear, inappropriate, imprecise (not the exact meaning), or it may have a different connotation (an idea or feeling that the word suggests) than what you intend to say. To revise, either delete the word or use a thesaurus to substitute another word which fits better. Check its definition in a dictionary.\n*Example:* The _gigantic_ little rodent squeezed into its mouse hole.\n*Revision:* The little mouse squeezed into its mouse hole.","id":"WC0.574099764137159"},{"abbreviation":"WordOrd","comment":"*Revise Word Order:*\nAdjectives are placed before nouns, and subjects before verbs, in sentences using the active voice. Place nouns which emphasize the main thought at the end of sentences.\n*Examples:* Both red and blue, chirped the birds. Birds seek freedom most of all.\n*Revisions:* The red and blue birds both chirped. What birds seek most of all is _freedom_.","id":"WordOrd0.5481228100608935"},{"abbreviation":"Rep","comment":"*Repetitive:*\nThis word or phrase has been used excessively. Use a pronoun, synonym, or restatement instead of repeating this word. Or simply revise the sentence to omit.\n*Example:* She carefully planned the party, being careful to listen to advice.\n*Revision:* She planned the party, being careful to listen to advice.","id":"Rep0.24974407315085245"},{"type":"text","abbreviation":"Delete","comment":"*Delete Expletive:*\nAn expletive is an unnecessary word which serves no grammatical function and provides no meaning. The expletives _here, there,_ and _it_ followed by \"to be\" verbs (_is, am, are, was, were, be, being,_ and _been_), frequently begin awkward sentences.\n*Examples:* Here (There) are four friends who work for the company. It is the race Ben ran that he won.\nTo eliminate the unnecessary _here, there,_ and _it_ sentence-starters, place the subject of the sentence at the beginning.\n*Revisions:* Four friends work for the company. Ben won that race.","id":"Delete0.3992394011186844"},{"type":"text","abbreviation":"RevWord","comment":"*Revise Complex Word:*\nA complex word is a difficult or technical word that does not fit the style of writing. Only use a difficult or technical word when a simpler word will not communicate the exact meaning intended. Be careful to use a word exactly as it is defined.\n*Example:* The children enjoy playing with their new canine.\n*Revision:* The children enjoy playing with their new dog.","id":"RevWord0.9347823516409224"},{"abbreviation":"Def","comment":"*Needs Definition:*\nThis term or word is not commonly understood or is used in a special way must be italicized. Support its definition and how you mean to use it with surrounding context clues, such as synonyms, antonyms, and examples. Alternately, provide its definition in parentheses or as an explanatory phrase, clause, or sentence.\n*Examples:* He promised revisions, because changes were necessary. The _zeitgeist_ (spirit of the times) remained hopeful.","id":"Def0.5936674021717925"},{"type":"text","abbreviation":"3rdPer","comment":"*Use Third-Person Point of View:*\nDon't use the first-person pronouns: _I, me, we, us, my, mine, our, ours, ourselves_ or the second-person pronouns: _you, your, yours, yourselves_ in your essay. Most essays are written in the third-person point of view to demonstrate objectivity (unbiased fair treatment). These third-person pronouns take the place of nouns:\n*▪ He, she, it, one, they* (subject case pronouns) \n*▪ Him, her, it, one, them* (object case pronouns)\n*▪ His, hers, its, theirs* (possessive pronouns)\n*▪ Himself, herself, itself, oneself, themselves* (reflexive/intensive pronoun)","id":"3rdPer0.2668239162191903"},{"abbreviation":"Slang","comment":"*Delete Slang:*\nDon't use slang in essays or other formal writing. Slang is informal language used with certain groups of people and in certain situations. It is more often used in conversation than in writing. Revise with formal language.\n*Example:* The _kids_ studied hard for their exams.\n*Revision:* The children studied hard for their exams.","id":"Slang0.3595578147789422"},{"abbreviation":"FigSp","comment":"*Delete Figure of Speech:*\nDon't use figures of speech in essays or other formal writing. A figure of speech is a non-literal expression. In other words, it means something different than its exact words.\n*Examples:* When asked how he felt about getting an F on the test, he said, \"Just terrific,\" (verbal irony) but he always responds like whining baby (simile). Revise with direct, literal, and formal language.","id":"FigSp0.5161593688651493"},{"type":"text","abbreviation":"IdmExp","comment":"*Delete Idiomatic Expression:*\nDon't use non-grammatical idiomatic expressions in essays or other formal writing. An idiomatic expression is a phrase or clause which cannot be translated word for word, and has a meaning of its own. Revise with formal language.\n*Example:* Jean let the _cat out of the bag_ about the plot of the upcoming episode.\n*Revision:* Jean revealed the plot of the upcoming episode.","id":"IdmExp0.6297379104036258"},{"abbreviation":"Contrct","comment":"*Delete Contraction:*\nDon't use contractions in essays or formal writing. A contraction is a shortened form of one or two words (one of which is usually a verb). An apostrophe takes the place of a missing letter(s) at the beginning, middle, or end of the word.\n*Examples:* They _shouldn't_ talk when they don't understand the subject.\n*Revision:* They should not talk when they do not understand the subject.\nNarratives often include contractions, especially in dialogue.","id":"Contrct0.8331937717043199"},{"type":"text","abbreviation":"Abbr","comment":"*Delete Abbreviation:*\nDon't use abbreviations in essays or formal writing. An abbreviation uses a period to shorten a word or words.\n*Examples:* _So._ Dakota is in the _U.S._\n*Revision:* South Dakota is in the United States.\nHowever, common acronyms may be used in essays or formal writing. An acronym is any abbreviation formed from the first letters of each word in a phrase. Frequently used acronyms do not require periods.\n*Example:* They copied the HTML (Hyper Text Markup Language) code.","id":"Abbr0.3824079137410279"},{"abbreviation":"PosWC","comment":"*Positive Word Choice Comment:*\nAccurate and creative word choice are the keys to successful writing. You have taken the effort to select words, which mean what you want them to communicate and which provide interest and readability in your writing.","id":"PosWC0.5281347276666102"}],"id":"Word Choice0.6294546309611821"},{"type":"default","name":"Nouns, Pronouns, Adjectives","comments":[{"abbreviation":"SpfNoun","comment":"*Use Concrete Noun:*\nAvoid using abstract nouns which cannot be perceived by the senses.\n*Example:* I read the _news_ about the _hunger problem_ in Africa. Instead, use specific, concrete nouns which can be perceived by senses. Often strong nouns do not need adjectives.\n*Example:* I read the article in the _Sacramento Bee_ about the famine and mass starvation in Liberia, Africa.","id":"SpfNoun0.14645756596451398"},{"type":"text","abbreviation":"RevNoun","comment":"*Revise with Noun Phrase or Clause:*\nRevise this section, using a noun phrase or noun clause. A noun phrase consists of a noun with any related words.\n*Example:* _The calm and decisive prince_ served his subjects well.\nA noun clauseis a dependent clause that usually begins with _if_, _how_, _however_, _that_, the \"wh\" words: _what_, _when_, _where_, _which_, _who_, _whom_, _whose_, _why_, or the \"wh\"-ever words: _whatever_, _whenever_, _wherever_, _whichever_, _who(m)ever_.\n*Example:* _Whatever she told you to do_, you should do.","id":"RevNoun0.6704718100944367"},{"abbreviation":"Gerund","comment":"*Revise with Gerund:*\nRevise this section, using a gerund or a gerund phrase. A gerund is an __ing_ verb that is used as a noun.\n*Example:* _Driving_ has become a necessary skill these days. A gerund phrase is an __ing_ verb, connected to related words, and is used as a noun.\n*Example:* _Driving a car_ has become a necessary skill these days.","id":"Gerund0.9815707754210901"},{"abbreviation":"RedPrn","comment":"*Reduce Pronoun Usage:*\nToo many pronouns in a sentence or paragraph create confusion for the reader. Replace some of the pronouns with concrete and specific nouns.\n*Example:* _She_ told _her_ that _he_ got _his_ from _them_.","id":"RedPrn0.6368300858508826"},{"type":"text","abbreviation":"SubPro","comment":"*Needs Subject Case Pronoun:*\nRevise with a subject case pronoun. Use the subject case pronouns: _I, you, he, she,_ and _it_ (singular) or _we, you,_ and _they_ (plural) for these functions:\n*▪* The subject of the sentence. A subject case pronoun that is part of a compound subject is placed last.\n*Examples:* Abel and _she_ attended the concert.\n*Substitution Trick:* Drop other nouns or pronouns in a compound subject to check if the remaining pronoun sounds right.\n*Example:* John and _I_ play video games. Drop and check‒ _I_ play video games.\n*▪* A predicate nominative, which identifies a subject following a \"to be\" verb (_is, am, are, was, were, be, being, been)_.\n*Example:* The man who got into trouble is _he_.\n*Substitution Trick:* Rephrase the sentence to check if the pronoun sounds right.\n*Example:* The last one to arrive was _he_ or _him_. Rephrase‒ _He_, not _Him_, was the last one to arrive.","id":"SubPro0.48469044471121436"},{"type":"text","abbreviation":"ObjPro","comment":"*Needs Object Case Pronoun:*\nRevise with an object case pronoun. Use the object case pronouns: _me, you, him, her, it_ (singular) or _us, you_,and _them_ (plural) for these functions:\n*▪* A direct object, answering What? or Whom? in response to the verb.\n*Example:* She hit _him_.\n▪ Place the object case pronoun last in compound objects.\n*Example:* The friend gave Kathy and _us_ a bag of chips.\n*Substitution Trick:* Drop other nouns or pronouns in a compound object to check if the remaining pronoun sounds right.\n*Example:* She gave it to John and _me_ or _I_. Drop and check‒She gave it to _me_, not _I_.\n*▪* As the object of a prepositional phrase.\n*Example:* They smiled at _me_.\n*▪* An indirect object, answering For What? or For Whom? in response to the verb. The indirect object is usually placed before the direct object in a sentence.\n*Example:* He gave _her_ a pen.\n*▪* As an object connected to an _infinitive_ (_to_ + the base form of a verb).\n*Example:* She wants _to give them_ money.","id":"ObjPro0.0170088835461224"},{"abbreviation":"ProRe-st","comment":"*Pronoun Re-statement Error:*\nDon't restate the subject twice with a pronoun in the same sentence. The subject is the \"do-er\" of the sentence.\n*Examples:* That dog, which is friendly, _he_ was easy to train.\n*Revision:* That dog, who is friendly, was easy to train.","id":"ProRe-st0.9111411054885463"},{"type":"text","abbreviation":"ProAnt","comment":"*Revise Pronoun Antecedent Issue:*\nAn antecedent is the word, phrase, or clause to which a pronoun refers. Use these revision strategies to clarify the connection between the pronoun and its antecedent:\n*▪* Place the pronoun close to its antecedent.\n*Example:* _John_, just like Peter, enjoyed _his_ sports.\n*Revision:* _John_ enjoyed _his_ sports, just like Peter.\n*▪* Change either the pronoun or antecedent to be more specific.\n*Example:* He gave _the dog_ _his bone_.\n*Revision:* He gave _Fido_ _the dog bone_.\n*▪* Don't use a pronoun that refers to the object of a preposition. The preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Example:* In Twain's _Tom Sawyer_, _he_ uses political humor.\n*Revision:* Twain uses political humor in _Tom Sawyer_.\n*▪* Use a singular pronoun to refer to the antecedent when the antecedent is uncountable.\n*Example:* _All_ of the salt fell out of _their_ bag.\n*Revision:* _All_ of the salt fell out of _its_ bag.\n*▪* Don't have a pronoun refer to a possessive antecedent.\n*Examples:* In San Diego's zoo, _they_ treat _their_ animals well.\n*Revision:* San Diego Zoo trainers treat their animals well.","id":"ProAnt0.544491219555389"},{"type":"text","abbreviation":"RelPro","comment":"*Correct Relative Pronoun:*\nYou used the wrong relative pronoun. Of the relative pronouns: _that_, _which_, _who_, _whom_, and _whose_, the pronoun _that_ can refer to people or things in general. Use _which_ for specific things and _who, whom,_ and _whose_ for specific people, animals, and characters.\n*Who and Whom Trick:* _Who_ is in the subject case and acts upon a verb. Substitute _he_ or _they_, rearrange the sentence to make sense,and check if it sounds right. _Whom_ is in the object case and receives the action of the verb. Substitute _him_ or _them_ and check if it sounds right.\n*Example:* She knows _whom_ she should ask. Substitute, rearrange, and check: She knows she should ask _him. Him_ sounds right, so _whom_ is correct.","id":"RelPro0.8580562740297613"},{"abbreviation":"TTTT","comment":"*Correct This, That, These, or Those:*\nYou used the wrong demonstrative pronoun or adjective here. The words, _this_ and _these_, refer to nouns or pronouns close to the writer, while _that_ and _those_ refer to nouns or pronouns away from the speaker or writer.\n*Examples:* _This_ right here and _that_ by the window (demonstrative pronouns) are heavier than _these_ desks in front of me and _those_ tables by the door (demonstrative adjectives).","id":"TTTT0.716347802271998"},{"type":"text","abbreviation":"PossPro","comment":"*Correct Possessive Pronoun:*\nThe possessive pronouns: _my, our, your,_ _his_, _her_, _its_ and _their_ must connect to nouns. They are called _determiners_, because they determine _whom_ belongs to the noun.\n*Example:* _Your_ friend. _Your_ determines whose friend it is.\nOther possessive pronouns: _mine, ours, yours,_ _his_, _hers_, and _theirs_ stand on their own and do not connect to nouns.\n*Example:* The pillow is _mine._\nOnly possessive pronoun determiners can also connect to a _gerund_ (a verb form ending in __ing_ that serve as a sentence subject).\n*Examples:* _His_ (not _Him_) cooking is not the best. _Their_ (not _Theirs_) housekeeping is not the best.","id":"PossPro0.2972579155215036"},{"abbreviation":"RefPro","comment":"*Correct Reflexive Pronoun:*\nReflexive pronouns end in \"self\" or \"selves\" and must refer to the subject (the \"do-er\") of the sentence. These pronouns are necessary to the meaning of the sentence: _myself_, _ourselves_, _yourself_, _yourselves_, _himself_, _herself_, _itself_, and _themselves_.\n*▪* Don't use a reflexive pronoun as the object of a prepositional phrase without reference to the sentence subject. The preposition shows a relationship between a word which signals location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Examples:* It was done by _yourself_.\n*Revision:* You did it by _yourself_.\n*▪* Don't use a reflexive pronoun as the sentence subject.\n*Examples:* Joe and _myself_ are playing cards.\n*Revision:* Joe and _I_ are playing cards.\n*▪* Don't use an object case pronoun (_me, you, him, her, it_, _us, you_, _them_) as a reflexive pronoun.\n*Example:* I got me a sandwich.\n*Revision:* I got myself a sandwich. I got a sandwich.","id":"RefPro0.14549444535245182"},{"abbreviation":"IntPro","comment":"*Correct Intensive Pronoun:*\nIntensive pronouns (_myself_, _ourselves_, _yourself_, _yourselves_, _himself_, _herself_, _itself_, and _themselves_) follow a noun or pronoun to add emphasis. They are unnecessary to the meaning of the sentence. Never use _ownself (as in my ownself), ourself,_ or _hisself, and don't use commas before or after the intensive pronoun._\n*Example:* He won _hisself_ the game.\n*Revision:* He _himself_ won the game.","id":"IntPro0.35445108432666217"},{"abbreviation":"Gender","comment":"*Revise Gender Pronoun Issue:*\nMake both the pronoun and its antecedent (the word, phrase, or clause to which a pronoun refers) plural when gender (male or female) does not need to be specified.\n*Example:* _Everyone_ needs _his_ rest.\n*Revision:* _All_ need _their_ rest.","id":"Gender0.33366503329577557"},{"abbreviation":"AdjOrd","comment":"*Revise Adjective Order:*\nAn adjective is placed before the noun it modifies (describes, identifies, defines, or limits) and answers Which one? How many? or What kind? of the noun. Avoid using adjectives that do not add meaning to a sentence, such as _interesting_, _beautiful_, _nice_, and _exciting_. Multiple adjective follow the Which one? How many? or What kind? order.\n*Examples:* She saw _these_ (Which one?) _two_ (How many?) _handsome_ (What kind?) men.","id":"AdjOrd0.9471824158332551"},{"type":"text","abbreviation":"PredAdj","comment":"*Correct Predicate Adjective:*\nA predicate adjective follows a linking verb to modify (describe, identify, define, or limit) the noun or pronoun before it. Linking verbs include \"to be\" verbs: _is, am, are, was, were, be, being,_ and _been_ and other state of being verbs, such as _become_, _seem_, _look_, _feel_, _smell_, and _appear_. Don't add the __ly_ onto the end of a predicate adjective.\n*Example:* I feel _proudly_.\n*Revision:* I feel _proud_.","id":"PredAdj0.4877539704552565"},{"abbreviation":"Article","comment":"*Correct Article:*\nAn article (_a_, _an_, _the_) is an adjective used before a noun or other adjective. The _a_ comes before a consonant sound; the _an_ comes before a vowel sound.Both _a_ and _an_ indicate unspecific things, while _the_ is specific.\n*Examples:* He wanted _an_ egg or _a_ tomato, but I gave him _the_ toast.","id":"Article0.8661265760270398"},{"type":"text","abbreviation":"Partcpl","comment":"*Correct Participle:*\nA participle is a verb form that serves as an adjective. Present participles end in __ing_.\n*Example:* I hear _running_ water. Past participles end in __d_, __ed_, or __en_; however, some have irregular forms, many of which end in __t_.\n*Examples:* said, frightened, given, built","id":"Partcpl0.2816780700729016"}],"id":"Nouns, Pronouns, Adjectives0.7432415897852542"},{"type":"default","name":"Verbs","comments":[{"type":"text","abbreviation":"SpfVb","comment":"*Use a More Specific Verb:*\nA verb is a mental or physical action (_think, act_) or links to the subject to create a state of being (_is, appears_). Using strong and specific verbs often do not require adverbs.\n*Example:* Pedro _runs fast_ toward the end zone.\n*Revision:* Pedro _sprints_ toward the end zone.","id":"SpfVb0.4302502861940418"},{"type":"text","abbreviation":"NounSV","comment":"*Correct Noun Subject-Verb Agreement:*\nThe verb does not match the subject noun (the \"do-er\" of the sentence). Follow these rules to match a verb to its noun subject:\n*▪* A singular noun subject makes the main verb end in s. A plural noun subject makes the main verb not end in s.\n*Examples:* John walks. John and Marci walk. The children walk.\n*▪* If matching a verb to a compound subject (two or more \"do-ers\" of the sentence) which does not include _and_, match the verb to the last noun in the compound subject.\n*Examples:* The tigers or the _lion_ _roars_ each day. Neither Tom _nor_ Elena _swims_.\n*▪* Collective nouns that refer to a group of individuals are usually singular.\n*Examples:* The _team__works_ together, but the _class_ _does_ not.\n*How to Identify the Subject:* To identify the subject noun, first eliminate all prepositional phrases and dependent clauses. Next, look for the main verb and then ask \"Who?\" or \"What?\" The answer is the subject.\n*Example:* The _flavors_ -of his snow cones- (prepositional phrase)  -which he developed last summer-, (dependent clause) _excite_ my taste buds. The main verb is _excite._ \"Who?\" or \"What?\" The answer is the subject: _flavors._ Because _flavors_ is a plural subject, it determines that the verb, _excite_, must not end in s.","id":"NounSV0.4771828409623138"},{"type":"text","abbreviation":"ProSV","comment":"*Correct Pronoun* *Subject-Verb Agreement:*\nThe verb does not match the subject (the \"do-er\" of the sentence) pronoun. Follow these rules to match a verb to its pronoun subject:\n*▪* A singular pronoun subject makes the main verb end in s. A plural pronoun subject makes the main verb not end in s.\n*Examples:* He walks. John and she walk. They walk.\n*▪* The first and second person subject case pronouns: _I, we,_ and _you_ match verbs that do not end in s.\n*Examples:* I _like_ it; we _love_ it; but you _hate_ it.\n*▪* The third person subject case pronouns: _he, she, it,_ and _they_ match verbs that do end in s.\n*Examples:* He _likes_ it; she _loves_ it. It _pleases_ everyone and they _ask_ for it.\n*▪* An indefinite singular pronoun matches a verb that ends in s.\n*Examples:* Anybody, Anyone, Anything, Each, Either, Everybody, Everyone, Everything, Neither, Nobody, Nothing, No one, One, Somebody, Someone, Something _seems_ loud, not _seem_ loud.\n*▪* An indefinite plural pronoun matches a verb that does not end in s.\n*Examples:* Both, Few, Many, Several _grow_ quickly, not _grows_ quickly.\n*▪* Indefinite number pronouns: _all_, _any_, _half_, _more_, _most_, _none_, _other_, and _some_ may be singular or plural depending upon the surrounding word clues.\n*Examples:* _None_ of _this_ _helps,_ but _m__ore_ of _these types_ _may_ do so.","id":"ProSV0.4641341431364674"},{"type":"text","abbreviation":"HelpVb","comment":"*Correct Helping Verb:*\nHelping verbs are added before main verbs to indicate present or past tense. They suggest an ongoing action, not a one-time event. Use the proper form of these verbs:\n*▪* The \"to do\" verbs: _do_, _does_, and _did_ connect to infinitives (base forms of the verbs). \n*Examples:* They _do_ help; Marta _does_ help; Jaime and Luis _did_ help.\n*▪* The \"to have\" verbs: _have_, _has_, and _had_ suggest an ongoing action for a specific amount of time and connect to past participles (verb forms ending in __d_, __ed_, or __en_ and irregular forms, many of which end in __t_).\n*Examples:* They _have_ said; Marta _has_ frightened; Jaime and Luis _had_ given\n*▪* The \"to be\" verbs: _is, am, are, was, be, being,_ and _been_ connect to present participles (verb forms ending __ing_).\n*Examples:* They _are_ helping; Marta _is_ helping; Jaime and Luis _were_ helping.\nDon't add more than one word between the helping verb and main verb.","id":"HelpVb0.27408329156524514"},{"type":"text","abbreviation":"Modal","comment":"*Correct Modal:*\nModals are verbs which are added before infinitives (base forms of the verbs) to indicate a condition in which there are alternative possibilities. The modals: _can_, _could_, _may_, _might_, _must_, _shall_, _should_, _will_, and _would_ do not change the tense of the verb.\n*Examples:* They _could_ help (not _helped_) the teacher if they wanted.\nModals are often placed before helping verbs, in which case the \"to have\" and \"to be\" verbs do change the verb endings.\n*Examples:* They _could_ have helped the teacher if they _would_ have been listening.\nDon't substitute _of_ for the _have_ after a modal.\n*Example:* They should _of_ have helped.\n*Revision:* They should _have_ helped.","id":"Modal0.05504313061187993"},{"type":"text","abbreviation":"LinkVb","comment":"*Correct Linking Verb:*\nA linking verb follows a subject (the \"do-er\" of the sentence) and links to another word which it modifies (describe, identify, define, or limit). Linking verbs include the \"to be\" verbs: _is_, _am_, _are_, _was_, _were_, _be_, _being_, _been_ and _become_, _feel_, _look_, _seem_, _smell_, _sound_, _taste_.\n*Example:* Lori _is_ strong.\n*▪* Don't substitute *be* or *been* for *is* or *was*.\n*Example*: He _be_ funny.\nDon't use the non-standard use of the \"do be\" or \"don't be\" patterns.\n*Examples:* _Do be_ listening and _don't be_ talking.\n*▪* Don't use the non-standard _was_ and _were_.\n*Examples:* We was friends and it were nice.\n*Revision:* We were friends and it was nice.\n*▪* Don't drop linking verbs.\n*Examples:* She nice, but I been nice to her first.\n*Revision:* She is (was) nice, but I had been nice to her first.","id":"LinkVb0.5537125794164941"},{"type":"text","abbreviation":"TransVb","comment":"*Transitive Verb Error:*\nThis transitive verb needs an object. A transitive verb is a mental or physical action that acts upon a direct object. The direct object answers _Whom_? or _What_? from the verb.\n*Example:* Lewis _gave_ (transitive verb) a wonderful gift (direct object).\nAn intransitive verb is a mental or physical action that acts without an object. Linking verbs are all intransitive verbs.\n*Example:* The baby _screams_ (intransitive verb) loudly.","id":"TransVb0.6347870045638868"},{"abbreviation":"VT","comment":"*Correct Verb Tense:*\nDon't mix verb tenses.English has three basic verb tenses to show time.\n*▪* The past verb tense adds \"_d\" or \"_ed\" at the end of the infinitive (base form of the verb) and does the past physical or mental action of the subject (the \"do-er\" of the sentence). These actions are one-time events that took place at a specific time.\n*Examples:* I _asked_ for it. You _appeared_ interested.\n*▪* The present tensedoes the present physical or mental action. The present verb tense is the infinitive (base form of the verb). A singular subject makes the present tense verb end in s (except _I, we,_ and _you_), but a plural subject matches a verb which does not end in s.\n*Examples:* He _swims_. Mandy and Mark _swim_.\n*▪* The present tensecan be used to generalize or to show repeated action.\n*Examples:* Everyone _knows_ that wearing helmets prevents injuries. I _wake_ up every morning at 6:00 a.m.\n*▪* The present tenseis used to discuss literature, art, movies, theater, and music (even if\nthe content is set in the past or the creator is no longer alive).\n*Examples:* Shakespeare _gives_ his characters unusual problems. _Rebecca_ is an old movie classic.\n*▪* The future tense is formed with _will_ or _shall_ + the infinitive (base form of the verb) to describe a physical or mental action in the future.Traditionally, _shall_ has been used to match the _I_ and _we_ pronouns.\n*Examples:* He _will_ stay, but I _shall_ go.\nPast, present, and future verb tenses are also determined by helping verbs: _did_ and _had_ (past)_, do, does,__have,_ and _has_ (present), _will_ _do,__will have,_ and _shall_(future) and the \"to be\" verbs: _was,__were,_ and _been_ (past), _is, am, be,_ and _are_ (present), and _will be_ and _shall be_ (future).","id":"VT0.40891112419100706"},{"abbreviation":"IrrgVb","comment":"*Correct Irregular Verb:*\nAn irregular verb does not form its past tense and past participle by adding a __d_, __ed,_ or __en_ ending onto the infinitive (base form of the verb). The most frequent irregular verb ending is __t_.\n*Examples:* bent, bit, bought, felt, fought, got, kept, left, sent, shot, wrote","id":"IrrgVb0.9169563206719695"},{"type":"text","abbreviation":"PstProg","comment":"*Correct Past Progressive Verb:*\nThe past progressive is a verb form that adds an __ing_ onto the infinitive (base form of the verb) and is placed after _was_ or _were_ to describe an ongoing past action. Frequently, the word _while_ is used in connection with the past progressive.\n*Example:* I _was day-dreaming_ while you talked.","id":"PstProg0.22959527039575"},{"type":"text","abbreviation":"PrProg","comment":"*Correct Present Progressive Verb Form:*\nThe present progressive is a verb form that adds an __ing_ onto the infinitive (base form of the verb) and is placed after _is, am,_ or _are_ to describe an ongoing action happening or existing now.\n*Example:* I _am walking_ to the store. Some verbs can't use the present progressive form: to be, to belong, to care, to cost, to exist, to envy, to fear, to hate, to like, to love, to mind, to need, to owe, to want.\n*Example:* I _be fearing_ it.\n*Revision:* I _fear_ it.","id":"PrProg0.8064930578936698"},{"type":"text","abbreviation":"FutProg","comment":"*Correct Future Progressive Verb:*\nThe future progressive is a verb form that adds an __ing_ onto the infinitive (base form of the verb) and is placed after a _will_ or _shall_ + _be_ to describe an ongoing action that will take place over a period of time in the future (while another action takes place) or to describe an ongoing future action that will be briefly interrupted by an action of less importance.\n*Examples:* She _will be eating_ while we play cards. We _shall be playing_ after the junior varsity.","id":"FutProg0.3186754757268233"},{"abbreviation":"PstPerf","comment":"*Correct Past Perfect Tense Verb:*\nThe past perfect is formed with _had_ + the past participle (a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_) to describe an action that was completed before a specific time or another specific action in the past.\n*Example:* They _had tried_ to compromise, until the opposition walked out.","id":"PstPerf0.4023798670986123"},{"abbreviation":"PrPerf","comment":"*Correct Present Perfect Tense Verb:*\nThe present perfect verb tense is formed with _has_ or _have_ + the past participle (a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_) and is used to describe an action that took place at some unidentified time in the past that relates to the present.\n*Example:* He _has talked_ a lot.","id":"PrPerf0.73604447160978"},{"abbreviation":"FutPerf","comment":"*Correct Future Perfect Tense Verb:*\nThe future perfect tense is formed with _will_ or _shall_ + _have_ + a past participle (a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_) to describe an action that will be completed before a specific time or another action in the future.\n*Example:* The kids _will have practiced_ for ten years by then.\nDon't use the future perfect tense to begin clauses with _when_, _while_, _before_, _after_, _by the time_, _as soon as_, _if_, _unless_. Use the present perfect tense instead.\n*Example:* While you _will have acted_ badly, I never would\n*Revision:* While you _have acted_ badly, I never would.","id":"FutPerf0.6695100590775069"},{"type":"text","abbreviation":"PstPerProg","comment":"*Correct Past Perfect Progressive Verb:*\nThe past perfect progressive form connects _had_ _been_ + a present participle (a verb ending in __ing_) to describe a past continuous action that began in the past and continued until another time or event.\n*Example:* Because I _had_ not _been studying_, I failed.","id":"PstPerProg0.7733281640989131"},{"abbreviation":"PrPerProg","comment":"*Correct Present Perfect Progressive Verb:*\nThe present perfect progressive form connects _has_ or _have_ + _been_ to a present participle (a verb ending in __ing_) to describe an action that began in the past, continues in the present, and may continue into the future.\n*Example:* I _have been eating_.","id":"PrPerProg0.3427673844316408"},{"type":"text","abbreviation":"FutPerProg","comment":"*Correct Future Perfect Progressive Verb:*\nThe future progressive form can connect _will_ _have_ _been_ + a present participle (a verb ending in __ing_) for an ongoing future action interrupted by another action.\n*Example:* She will have been waiting for one hour when the bus arrives.","id":"FutPerProg0.6554643165064002"},{"abbreviation":"Active","comment":"*Change to Active Voice:*\nIn the active voice, the subject (the \"do-er\" of the sentence) performs the action of the main verb. In the passive voice, the subject receives the action. Use the active in essays and narratives unless the subject is unknown or unimportant.\n*Example:* It was said by me.\n*Revision:* I said it.","id":"Active0.5669219947061264"},{"abbreviation":"Passive","comment":"*Change to Passive Voice*\nIn the passive voice, the subject (the \"do-er\" of the sentence) receives the action of the main verb. Use the passive voice when the subject is unknown or unimportant. Also use the passive voice in scientific writing to focus on objective data, not the sentence subject.\n*Example:* About 25% received the pill in the research group. Not... I gave the pill to about 25% of the research group.","id":"Passive0.30373352541243315"}],"id":"Verbs0.844215548467653"},{"type":"default","name":"Modifiers, Adverbs, Prepositions, Conjunctions","comments":[{"type":"text","abbreviation":"CompMod","comment":"*Correct Comparative Modifier:*\nA comparative modifier is an adjective or adverb that modifies two things. Follow these rules to use comparative modifiers correctly:\n*▪* Use the suffix \"_er\" for a one-syllable modifier.\n*Example:* She is _short-er_ than I.\n*▪* Use __er_ or _more (less)_ for a two-syllable modifier.\n*Example:* He seems _more help-ful_ than they.\n*▪* Use _more_ or _less_ for a three-syllable (or longer) modifier.\n*Example:* Frank was _more gen-er-ous_ than Keith.\n*Example:* Frank was _more gen-er-ous_ than Keith.\n*▪* Use _more_ or _less_ for all adverbs ending in \"_ly.\"\n*Examples:* She apologized _more con-vin-cing-ly_ than did her friend.","id":"CompMod0.22510530957673902"},{"type":"text","abbreviation":"SupMod","comment":"*Correct Superlative Modifier:*\nA superlative modifier is an adjective or adverb that modifies three or more things Follow these rules to use superlative modifiers correctly:\n*▪* Use the suffix \"_est\" for a one-syllable modifier.\n*Example:* Of Rachel, Tim, and Sam, Rachel is the _smart-est_.\n*▪* Use __est_, _most_, or _least_ for a two-syllable modifier.\n*Example:* Of Rachel, Tim, and Sam, Rachel has the _most tal-ent_).\n*▪* Use _most (least)_ for a three-syllable or longer modifier.\n*Example:* Of the five contestants, Jane spoke _most care-ful-ly_.","id":"SupMod0.06631343735435857"},{"type":"text","abbreviation":"MisMod","comment":"*Revise Misplaced Modifier:*\nThis modifier is misplaced. A modifier should be placed, whenever possible, next to the word it modifies (describes, identifies, defines, or limits).\n*Example:* The modifier in the following sentences is _only_: She _only_ requested two appetizers.\n*Revision:* She requested _only_ two appetizers.","id":"MisMod0.8173054421269219"},{"type":"text","abbreviation":"DangMod","comment":"*Revise Dangling Modifier:*\nRevise this dangling modifier. A dangling modifier is an adjective or adverb which is not directly connected to the subject and so creates confusion for the reader.\n*Example:* Wanted: Someone to care for an old elephant who does not smoke or drink liquor.\n*Explanation:* The modifier, \"who does not smoke or drink liquor\" is not directly connected to \"Someone\" and appears to be connected to \"an old elephant.\" Obviously, elephants do not smoke or drink liquor, but the sentence unintentionally suggests that they do.","id":"DangMod0.2960531162266655"},{"type":"text","abbreviation":"AdvOrd","comment":"*Revise Adverb Order:*\nAn adverb modifies (describes, identifies, defines, or limits) a verb, an adjective, or an adverb by answering How? When? Where? or What Degree? The adverb may be found before or after the word or words that it modifies (describes, identifies, defines, or limits). Follow these rules to use adverbs correctly:\n*▪* Multiple adverbs follow the How? When? Where? or What Degree? order.\n*Examples:* _Carefully_, you _soon_ may walk _where_ tigers _mostly_ roam.\n*▪* As a matter of good writing style, place shorter adverbial phrases in front of longer ones.\n*Example*: The family walks _around the block after every Thanksgiving Dinner_. Explanation: The phrase _around the block_ is shorter than _after every Thanksgiving_.\n*▪* As a matter of good writing style, place specific adverbs before general ones.\n*Example:* It should be _exactly where_ I described, _next_ to the desk, or _somewhere over there_.\n*Explanation:* The specific adverbs _exactly where_ and _next_ come before _somewhere over there_.\n*▪* Avoid overusing such adverbs as _very_ that add little meaning to a sentence.\n*Example:* That is a _very_ interesting idea.","id":"AdvOrd0.15450212242638584"},{"type":"text","abbreviation":"HyphMod","comment":"*Correct Hyphenated Modifier:*\nBoth adjectives, which modify (describe, identify, define, or limit) nouns and answer Which one? How many? or What kind?, and adverbs, which modify a verb, an adjective, or an adverb and answer How? When? Where? or What Degree?, may be combined with hyphens (-) to form compound modifiers.\n*▪* Use a hyphen to join a compound adjective to modify a single noun or pronoun. Don't use a hyphen if you can use the word _and_ between the two adjectives.\n*Examples:* world-famous hot dogs; warm, comfortable coat (warm and comfortable, not warm-comfortable)\n*▪* Use a hyphen to join a compound adverb when used before nouns.\n*Example*: The much-requested song.\n*▪* When the compound adverb is after the noun, don't hyphenate.\n*Example*: Her wishes were always well known.","id":"HyphMod0.8830593295120603"},{"abbreviation":"Prep","comment":"*Revise Preposition Issue:*\nA preposition is always part of a prepositional phrase. The preposition shows a relationship between a word indicating location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Example:* He ran _up the road_.\n*Explanation:* The preposition, _up_, asks, \"What?\" and the object, _the road_, provides the answer. Follow these rules to use prepositions properly:\n*▪* Don't string together more than two prepositional phrases.\n*Example:* Peter Rabbit ran _through the field, under the fence, into the garden_.\n*Revision:* Peter Rabbit ran _through the field_. Afterwards, he ran _under the fence_ and _into the garden_.\n*▪* Don't add the _of_ or _on_ prepositions when unnecessary.\n*Examples*: Get off -of- my couch. Don't blame -on- me for that.\n*▪* Avoid ending sentences with awkward prepositions.\n*Example:* The cook did not know what the pie was made of.\n*Revision:* The cook did not know the ingredients in the pie.","id":"Prep0.5149482816024864"},{"abbreviation":"CoConj","comment":"*Needs Coordinating Conjunction:*\nCoordinating conjunctions join words, phrases, or clauses of equal importance.\n*Examples:* I need one _or_ two. He also brought along two water bottles, _yet_ he did not know why.\n*Memory Trick (to remember the coordinating conjunctions):* *FANBOYS* (For-And-Nor-But-Or-Yet-So)","id":"CoConj0.12783113190779583"},{"abbreviation":"CorConj","comment":"*Needs Correlative Conjunction:*\nCorrelative conjunctions are pairs of conjunctions which join words, phrases, or clauses. The pairs include _both-and_, _not only-but also_, _either-or_, _whether-or_, _neither-nor_.\n*Example:* Both Jake _and_ Kenny went to college.","id":"CorConj0.352936503099885"},{"type":"text","abbreviation":"SubConj","comment":"*Needs Subordinating Conjunction:*\nA subordinating conjunction begins an adverbial clause to indicate time (_when_), cause-effect (_if_), or exception (_although_). The adverbial clause is a dependent clause (a noun and a connected verb that does not express a complete thought) that is subordinate to (of less importance than) the connected independent clause (a noun and connected verb which expresses a complete thought). The subordinating conjunction signals that dependent and subordinate position.\n*Example:* _Unless_ you give me permission, I will not act.\n*Explanation:*_Unless_ signals that the rest of the clause: \"you give me permission\" is dependent upon and subordinate to the independent clause: \"I will not act.\"\n*AAAWWUBBIS Memory Trick* *(to remember the subordinating conjunctions):* Most dependent clauses begin with these words: _After,_ _Although,_ _As,_ _When,_ _While,_ _Until,_ _Because,_ _Before,_ _If,_ or _Since_.","id":"SubConj0.9875602154989103"}],"id":"Modifiers, Adverbs, Prepositions, Conjunctions0.27742202388976533"},{"type":"default","name":"Punctuation, Capitalization, Quotation Rules","comments":[{"type":"text","abbreviation":"SpTagCm","comment":"*Correct Speaker Tag Comma:*\nFollow these rules for comma placement with speaker tags (the speakers and speech-related verbs) in dialogue:\n*▪* Place commas after a beginning speaker tag to the left of the quotation marks.\n*Example:* He said, \"I shouldn't listen to what you say.\"\n*▪* Place commas before and after a middle speaker tag to the left of both quotation marks.\n*Example:* \"But if you don't, he shouted \"you will never win.\"\n*▪* Place commas before an ending speaker tag to the left of the quotation marks.\n*Example:* \"Okay. I will give you another chance,\" he responded.\nQuestion marks and exclamation points are placed in the same positions as commas.","id":"SpTagCm0.6161029117449053"},{"abbreviation":"DrAddCm","comment":"*Correct Direct Address Comma:*\nFollow these rules for comma placement with nouns of direct address (the character spoken to) in dialogue:\n*▪* If the noun of direct address is placed at the beginning of the sentence, place a comma after that noun.\n*Examples:* Kristen, leave some for your sister. Officer Daniels, I need your help.\n*▪* If the noun of direct address is placed in the middle of the sentence, place commas before and after that noun.\n*Examples:* If you insist, Dad, I will. If you insist, Your Honor, I will.\n*▪* If the noun of direct address is placed at the end of the sentence, place a comma before that noun.\n*Examples:* Just leave a little bit, honey. Just leave a little bit, you selfish monster.","id":"DrAddCm0.8373899436459598"},{"type":"text","abbreviation":"AbbrCm","comment":"*Correct Commas with Abbreviations:*\nFollow these comma rules with abbreviations: Place commas before and after degree or job title, and family title, and Latin abbreviations unless the abbreviation ends the sentence.\n*▪* Educational degrees and job titles which follow peoples' last names. Job titles which precede names don't have commas.\n*Examples:* Maureen Johnson, M.D., became a medical doctor in 2019. Lacy Smith, C.E.O., was the first chief executive officer of that corporation. Sgt. O'Rourke became a sergeant and Dr. Lang became a doctor in 2018.\n*▪* Family titles which follow peoples' last names. Family titles which follow first names don't have commas.\n*Examples*: Maurice Small, IV, was listening to John Jr. and John Sr.\n*▪* Latin abbreviations\n*Example:* He likes them all: cake, cookies, etc. (means _and so on)_\n*Example:* I love ice cream, e.g., vanilla. (means _for example_)\n*Example:* He is goofy, i.e., silly. (means _that is_ or _in other words_)","id":"AbbrCm0.19251638403353422"},{"abbreviation":"SerCm","comment":"*Correct Commas in Series:*\nPlace commas after each item in lists, except the last one. Newspapers, web articles, and some magazines eliminate the last comma; however, most style manuals still require the last comma.\n*Example:* John, Jane, and Jose left early.","id":"SerCm0.9761992837296611"},{"abbreviation":"IntroCm","comment":"*Needs Introductory Word(s) Comma:*\nPlace commas after introductory words or phrases which have special emphasis. Place a comma after introductory prepositional phrases with more than four words.\n*Examples:* _First_, listen to me. _Throughout the rest of the book_, the characters do not change. _From there_ they went to the party.","id":"IntroCm0.51673070197444"},{"type":"text","abbreviation":"GeogCm","comment":"*Correct Comma with Geography:*\nPlace commas between related geographical place names and after the last place name unless it appears the end of a sentence. When the place name is a possessive, this rule does not apply.\n*Examples:* She lived in Rome, Italy, for a year. Rome, Italy's traffic is congested.","id":"GeogCm0.8605374851837628"},{"abbreviation":"DatesCm","comment":"*Correct Comma with Dates:*\nPlace commas between the number date and its year and after the year unless it appears at the end of the sentence.\n*Example:* We left town on May 4, 1999, before the storm arrived.","id":"DatesCm0.16978829514717853"},{"abbreviation":"AdjCm","comment":"*Correct Commas with Adjectives:*\nPlace commas to separate coordinate adjectives. Coordinate adjectives are two or more adjectives that modify (describe, identify, define, or limit) a noun or pronoun in the same way. If you can add _and_ between the adjectives and reverse their order, commas must separate them.\n*Examples:* A friendly, kind man visited us.\n*Explanation:* A friendly _and_ kind man. A kind, friendly man. Both make sense, so commas are required between the coordinate adjectives.\nDon't use commas to separate cumulative adjectives. Cumulative adjectives are two or more adjectives that modify (describe) a noun or pronoun in different ways. If you can't add _and_ between the adjectives and reverse their order, don't separate them with commas.\n*Examples:* It's a big green bug.\n*Explanation:* It's a big _and_ green bug. It's a green big bug. Neither makes sense, so don't use commas between the cumulative adjectives.","id":"AdjCm0.27021213718391346"},{"abbreviation":"CompCm","comment":"*Correct Comma with Compound Sentence:*\nPlace commas before coordinating conjunctions (_for, and, nor, but, or, yet, so_) to join two long independent clauses. An independent clause is a noun and connected verb which tells a complete thought. If one or both of the independent clauses is less than five words, no comma is necessary.\n*Examples:* I liked her so much, _and_ she liked me more than I thought. I love him and he loves me.\n*▪* Don't join two independent clauses with a comma. This is known as a _comma splice._\n*Example:* They say they know what they are doing, they really have no idea how to proceed. *Revision:* They say they know what they are doing, but they really have no idea how to proceed.\n*▪* Use commas before the second of the paired correlative conjunctions to join two independent clauses.\n*Example:* _Either_ he must go, _or_ you must go.","id":"CompCm0.1318791283288343"},{"abbreviation":"DepClCm","comment":"*Correct Comma with Dependent Clause:*\nA dependent clause includes a noun and connected verb, but it does not tell a complete thought. Follow these rules to place commas with dependent clauses:\n*▪* If a dependent clause begins a sentence, place a comma after the clause.\n*Example:* _When he asked me_, I told him.\n*▪* If the dependent clause is in the middle of the sentence, place commas before and after the clause.\n*Example:* Jonna was sure, _since she had checked_, that she had turned the lights off.\n*▪* If a dependent clause ends the sentence, don't begin with a comma.\n*Example:* She left _after I did_.\n*▪* Place commas before and after (unless it ends the sentence) a dependent clause that begins with _which_, _who_, _whom_, or _whose_ if it simply adds information and doesn't limit the meaning of the connected independent clause (a noun and connected verb which tells a complete thought).\n*Example:* The jacket, _which mom wore yesterday_, was green.\n*▪* Don't use commas before and after (unless it ends the sentence) a dependent clause that begins with _which that_, _who_, _whom_, or _whose_ if it limits the meaning of the connected independent clause (a noun and connected verb which tells a complete thought).\n*Example:* The student _who wins the most votes_ will be elected Student Council President.","id":"DepClCm0.8695023928190504"},{"abbreviation":"ParExpCm","comment":"*Correct Commas with Parenthetical Expression:*\nPlace commas before and after words that interrupt the flow of the sentence.\n*Examples:* The best way to see the game, _if you can afford it_, is in person.\nPlace commas to set apart _appositives_. An appositive is a noun or pronoun placed next to another noun or pronoun to identify, define, or describe it.The appositive can be a word, phrase, or clause.\n*Example:* That man, _the one with the hat_, left town quickly.","id":"ParExpCm0.1522557557021127"},{"abbreviation":"ColonCm","comment":"*Correct Colon:*\nFollow these rules to use colons properly:\n*▪* Use a colon following a noun to signal a list. Don't capitalize the first word in the list unless it is a proper noun.\n*Examples:* Bring home these items: tortillas, sugar, and milk. Text these people: James, Paul, and your mother.\n*▪* Use a colon to show a relationship between numbers.\n*Example:* At 8:02 p.m. the ratio of girls to boys at the dance was 3:1.\n*▪* Use a colon to show a relationship within titles.\n*Example:* Many people are familiar with \"_Psalm 23_\" and refer to it as \"The Lord is My Shepherd: Psalm 23.\"\n*▪* Use a colon after business letter greetings.\n*Example:* To Whom It May Concern: Thank you for your employment application.","id":"ColonCm0.7222081723435883"},{"abbreviation":"SemiCol","comment":"*Correct Semicolon:*\nUse semicolons to join independent clauses (nouns and connected verbs which express complete thoughts) with or without conjunctions.\n*Examples:* Anna showed up late; Louise didn't at all. Anna showed up late; however, Louise didn't at all.\nSemicolons combine related phrases or dependent clauses.\n*Example:* The children enjoy jumping into puddles; they love climbing trees; they also like making mud pies.","id":"SemiCol0.3839333040262283"},{"abbreviation":"ExclPnt","comment":"*Correct Exclamation Point:*\nUse one exclamation point to show strong emotion or surprise at the end of intentional fragments (parts of sentences) and exclamatory sentences. Don't use exclamation points in essays or formal writing.\n*Examples:* Wow! How amazing! The decision really shocked me!","id":"ExclPnt0.6633097470714149"},{"type":"text","abbreviation":"SgPossAp","comment":"*Correct Apostrophe with a Singular Possessive Noun:*\nA possessive is a noun or pronoun that serves as an adjective to show ownership. Follow these rules to use singular possessives properly:\n*▪* When ending in an s having a /z/ sound, place an apostrophe, then an s, or simply end with an apostrophe.\n*Examples:* _Charles's_ friend or _Charles'_ friend is fun.\n*▪* A singular possessive noun can connect to gerunds(verb forms ending in \"ing\" that serve as sentence subjects).\n*Example:* _Joe's cooking_ is not the best.\n*▪* Place the apostrophe before the s for singular indefinite pronouns used as possessives.\n*Examples:* Now it is _anybody's_, _everybody's_, _somebody's_, _somebody else's_, _either's_ ballgame.\n*▪* Don't use an apostrophe with a possessive pronoun (yours, his, hers, ours, yours, its, theirs).\n*Examples:* That plate is _your's_.\n*Revision:* That plate is _yours_.","id":"SgPossAp0.48380132781650476"},{"abbreviation":"PlPossAp","comment":"*Correct Apostrophe with a Plural Possessive Noun:*\nA possessiveis a noun or pronoun that serves as an adjective to show ownership. Follow these rules to use plural possessives properly.\n*▪* For a plural possessive of a singular word that doesn't end in s, place the apostrophe after the s. If the singular and plural forms are spelled differently, place the apostrophe before the s.\n*Examples:* The _girls'_ team is good, but the _women's_ team isn't.\n*▪* For a plural possessive of a singular word that does end in s, add \"es\" and then the apostrophe.\n*Example:* Our stove worked better than the _Thomases'_ stove.\n*▪* When two or more words share joint ownership, the possessive form is used only for the last word.\n*Example:* _Matt and Suzanne's_ wedding was the social event of the season.\n*▪* When two or more words are combined to show individual ownership of something, the possessive form is used for each of the words.\n*Examples:* _Linda's_, _Christie's_, and _Wendy's_ dresses were each individually designed.","id":"PlPossAp0.08396157967607887"},{"abbreviation":"(Par)","comment":"*Correct Parentheses:*\nUse parentheses following words to identify, explain, or define the preceding (before) word, phrase, or clause.\n*Examples:* That shade of lipstick (the red) goes perfectly with her hair color.\nEnding punctuation is placed outside of words or phrases within parentheses, but inside when the parenthetical remark stands on its own as a complete sentence.\n*Examples:* I want that Popsicle® (the orange one). He was crazy. (He didn't even know what day it was.)","id":"(Par)0.766766627752083"},{"abbreviation":"Cap","comment":"*Correct Capitalization:*\nFollow these capitalization rules:\n*▪* Capitalize proper nouns: named people, places, and things (including titles). Do not capitalize an article (_a_, _an_, _the_) that is part of the noun phrase unless it begins the phrase.\n*Examples:* _Alex the Great_ was honored (person) at _U.S. Memorial Auditorium_ (place) with the _Smith-Lee Award_ (thing).\n*▪* If the noun is hyphenated, capitalize both words before and after the hyphen when the nouns or adjectives have equal importance.\n*Example:* The Twentieth-Century was haunted by two world wars.\nHowever, don't capitalize the word after a hyphen if both words make up a single word or if the second word is a participle modifying the first word.\n*Examples:* Top Twenty Large-sized Models and English-language Arts\n*▪* Do not capitalize common nouns: unnamed people, places, things, and ideas.\n*Examples:* It takes _self-control_ (idea) for a _teenager_ (person) to drive to _school_ (place) in a _sports car_ (thing).","id":"Cap0.01929638803383571"},{"abbreviation":"Titles","comment":"*Correct Title Punctuation:*\nAs a general rule, use quotation marks before and after titles of short texts; titles which are parts of a whole; or titles of things that cannot be picked up from a desk.\n*Examples:* articles, television episodes, acts in a play, videos, short stories, reports.\nAs a general rule, use italics for titles of long texts; titles of whole things; or titles of things that can be picked up from a desk.\n*Examples:* magazines, newspapers, long narrative poems, movies, albums, television shows, plays","id":"Titles0.9970580635219395"},{"abbreviation":"DiaQuote","comment":"*Correct Dialogue Quotation:*\nRemember that a change in speaker requires a new paragraph. Capitalize the first word in a quoted sentence. Don't capitalize the first word of a continuing quote that was interrupted by a speaker tag.\n*Examples:* She said, \"You are crazy. However,\" she paused, \"it is crazy to be in love with you.\"\nInclude quotation marks before and after the speaker's words. Place commas and periods inside (to the left) of the closing quotation marks.\n*Examples:*\n\"I think you're wrong,\" said Victor.\nSal replied, \"I know I'm right.\"\nWhen dialogue is interrupted by comments or speaker tags, and then continues in the same sentence, begin the rest of the dialogue with a lower case letter.\n*Examples:* \"I realize,\" she paused to reconsider \"that I may have been mistaken.\" \"You are crazy. However,\" she paused, \"it is crazy to be in love with you.\"","id":"DiaQuote0.8038221849285376"},{"abbreviation":"DrQuote","comment":"*Correct Direct Quotation:*\nFollow these rules for direct quotations:\n*▪* When using the exact words of an author, this is known as a _direct quotation_. Include quotation marks before and after the author's exact words. The citation of the author or title and page number are placed within parentheses following the quotation and end with a period.\n*Examples:* The author stated, \"Over 90% of Americans support the law\" (Shetler 32).\n*▪* Don't use _dropped quotations_. A dropped quotation is a direct quotation used without an introduction. Always use a signal phrase to introduce a direct quotation.\n*Signal Phrase Examples:* The author suggests (adds, argues, asserts, cites, claims, describes, discusses, emphasizes, lists illustrates, notes, observes, reports, states)\n*▪* Place question marks and exclamation points inside (to the left) of quotation marks, if part of the quoted sentence, but outside (to the right), if not.\n*Examples:* Dr. Mosely comments, \"What if the studies are proven wrong?\" (Shetler 33). Did Dr. Mosely mean \"studies are proven wrong\"? (Shetler 33).\n*▪* Colons and semicolons go outside the closing quotation marks.\n*Examples:* \"Ask not what your country can do for you. Ask what you can do for your country\" (Kennedy): these words were President John F. Kennedy's most memorable. Kennedy explained, \"We shall pay any price, bear any burden, meet any hardship, support any friend, oppose any foe to assure the survival and success of liberty\"; however, he continued, \"All this will not be completed within the first one hundred days\" (Kennedy).","id":"DrQuote0.936441047704597"},{"abbreviation":"IndQuote","comment":"*Correct Indirect Quotation:*\nAn _indirect quotation_ uses the author's idea, but not the exact words, so no quotation marks are used. The paraphrase must be accurately to preserve the source's ideas. Use only your own words to paraphrase.\n*Example:* The author said that the species was endangered (Johns 45).","id":"IndQuote0.8761636923036442"},{"abbreviation":"QinQ","comment":"*Correct Quotation within a Quotation:*\nUse single quotation marks inside a quotation for a quotation or a title in quotation marks within a quotation.\n*Example:* He asked, \"What did Dr. King mean by 'free at last' in his famous speech?\"","id":"QinQ0.634965142926025"},{"type":"text","abbreviation":"RedQuote","comment":"*Reduce Direct Quotation:*\nThis quotation is too long and can be made more concise (brief) without changing the author's point.\n*▪* Remove words from a direct quotation by using the ellipsis (...) inside the quotation marks. Only remove information that is irrelevant (that which does not directly apply) from the quotation.\n*Example:* The author suggests that \"Rural counties... face challenges that urban counties do not\" (Abner 35).\n*▪* You may also choose to substitute an unfamiliar word with a better word choice by surrounding the new word choice with brackets.\n*Example:* The rapper sang, \"Don't talk [nonsense] if you don't wanna hear.\"\n*▪* Additionally, indicate a spelling or grammatical error by including [sic] following the error. \n*Example:* The mayor texted, \"Why don't they teach speling [sic] anymore?\"","id":"RedQuote0.5840145159755268"},{"abbreviation":"BlkQuote","comment":"*Needs Block Quote Citation:*\nFor any quotation of more than four lines, indent one-half inch from the margin and double space without quotation marks. If the quotation has more than one paragraph, indent the first line of the second paragraph an extra 1/4 inch.","id":"BlkQuote0.6412599771964298"}],"id":"Punctuation, Capitalization, Quotation Rules0.6918547263331025"},{"type":"default","name":"Spelling Rules","comments":[{"type":"text","abbreviation":"i bef e","comment":"*_i_ before _e_ Spelling Rule Error:*\nUsually spell _i_ before _e (believe)_, but spell _e_ before _i_ after a _c (receive)_ and when the letters are pronounced as a long /a/ sound _(neighbor)_. The rule only applies to the _i_ and _e_ spelling combination within one syllable, so the rule does not apply to words such as _sci-ence_. The rule doesn't apply to plurals of words ending in \"_cy\".\n*Examples:* delicacies, frequencies, vacancies.\n*Exceptions:* neither, either, weird, forfeit, caffeine, height","id":"i bef e0.4808060663836202"},{"type":"text","abbreviation":"Final y","comment":"*Final* _*y*_ *Rule Spelling Rule Error:*\nKeep the _y_ when adding an ending if the word ends in a vowel, then a _y (delay-delayed)_, or if the ending begins with an _i_ _(copy-copying)_. Change the _y_ to _i_ if the word ends in a consonant, then a _y_ _(pretty-prettiest)_.\n*Examples:* employ−employed, baby−babying, lovely−lovelier\n*Exceptions:* dryly, dryness, shyly, shyness, slyly, and slyness.","id":"Final y0.7905142247287991"},{"type":"text","abbreviation":"Silent e","comment":"*Silent* _*e*_ *Rule Spelling Rule Error:*\nDrop the silent _e_ at the end of a root when adding a suffix if that suffix begins with a vowel _(have-having)_. Some British spellings drop the silent final _e_ when the suffix begins with a consonant.\n*Examples:* judgment and argument.\nKeep the silent _e_ when the ending begins with a consonant _(close-closely)_, has a soft _/c/_ or _/g/_ sound-then an \"ous\" _(gorgeous_) or \"able\" _(peaceable)_, or if it ends in \"ee\", \"oe\", or \"ye\" _(freedom, shoeing, eyeing)._","id":"Silent e0.35907792050766996"},{"type":"text","abbreviation":"DbCons","comment":"*Double the Consonant Rule Spelling Rule Error:*\nFollow these rules for double consonant spellings:\n*▪* Double the ending consonant of a root, when adding a suffix _(permitted)_ if all three of these conditions are met: 1. The last syllable has the accent _(per / mit)_ 2. The last syllable ends in a vowel, then a consonant _(permit)._ 3.The suffix begins with a vowel _(ed)._\n*Examples:* admittance, commitment\n*▪* Don't double the ending consonant of a root when adding a suffix if the root ends in _k_, _w_, _x_, _y_, or _z_.\n*Examples:* locked, knowing, boxed, saying, lazier\n*▪* Don't double the ending consonant of a root when adding a suffix if the root ends in a vowel team followed by a consonant.\n*Examples:* hauling, howling, appealed","id":"DbCons0.5660928494046045"},{"type":"text","abbreviation":"an en","comment":"*\"an\" or \"en\" Suffix Rule Spelling Rule Error:*\nEnd a word with \"ance\", \"ancy\", or \"ant\" if the root before has a hard _/c/_ or _/g/_ sound _(vacancy, arrogance_) or if the root ends with \"ear\"or\"ure\" _(clearance, insurance)_.End a word with \"ence\", \"ency\", or \"ent\"if the root before has a soft _/c/_ or _/g/_ sound _(magnificent, emergency),_ after \"id\" _(residence),_ or if the root ends with \"ere\" _(reverence)._","id":"an en0.13593458095249122"},{"type":"text","abbreviation":"able ible","comment":"*\"able\" or \"ible\" Spelling Rule Error:*\nEnd a word with \"able\" if the root before has a hard _/c/_ or _/g/_ sound _(despicable, navigable),_ after a complete root word _(teachable),_ or after a silent _e (likeable)_. End a word with \"ible\" if the root has a soft _/c/_ or _/g/_ sound _(reducible, legible),_ after an \"ss\" _(admissible),_ or after an incomplete root word _(audible)._","id":"able ible0.5521965322467728"},{"type":"text","abbreviation":"/ion/","comment":"*/ion/ Spelling Rule Error:*\nFollow these rules for /ion/ sound spellings:\n*▪* Spell \"sion\" _(illusion)_ for the final _zyun_ sound or the final _shun_ sound _(expulsion, compassion)_ if after an _l_ or _s_. [_sion](http://blog.penningtonpublishing.com/wp-content/uploads/2018/12/sionion-Spelling-Worksheets.pdf)\n*▪* Spell \"cian\" for the final _shun_ sound suffix to indicate a person who does the task of the root _(musician, magician)_ and \"tion\" _(condition)_ in most all other cases. [_cian] (http://blog.penningtonpublishing.com/wp-content/uploads/2018/12/cianion-Spelling-Worksheets.pdf)\n*▪* Spell \"tion\" _(condition)_ for the final _shun_ unless after an _l_ or _s_ sound (\"_sion\") or unless the suffix indicates a person (\"_cian\").","id":"/ion/0.7765120758439434"},{"type":"text","abbreviation":"Plural","comment":"*Plurals Spelling Rule Error:*\nFollow these rules for plural spellings:\n*▪* To form plurals, add _s_ onto the end of most nouns _(dog-dogs),_ even those that end in _y (day-days)_ or those that end in a vowel, then an _o (stereo-stereos)._\n*▪* To form a plural when a noun ends in these sounds: _/s/_, _/x/_, _/z/_, _/ch/_, or _/sh/_, add \"es\" _(loss-losses, fox-foxes, box-boxes, buzz-buzzes, march-marches, marsh-marshes)_. To form plurals when words end in a consonant, then an _o_, add \"es\" _(potato-potatoes)._\n*▪* To form a plural when a noun ends in a consonant, then a _y_, change the final _y_ to _i_ and add \"es\" _(ferry-ferries)_.\n*▪* To form a plural when a noun ends in \"fe\" or \"lf,\" change these spellings to \"ves\" _(knife-knives, shelf-shelves)._\n*▪* To form a plural of a name ending in _s_, add \"es.\"\n*Examples:* _Jones_ forms the plural _Joneses_ and _Chris_ forms _Chrises_.\n*▪* Some singular nouns do not change spellings when forming plurals.\n*Examples:* aircraft, bison, deer, moose, salmon, sheep, swine, fish, and trout.","id":"Plural0.9775642984681965"}],"id":"Spelling Rules0.25910895503428266"},{"type":"default","name":"End Comments","comments":[{"abbreviation":"Potent","comment":"*Potential:*\nThis first draft has real potential. For your second draft, focus your revisions on ✖.","id":"Potent0.8307454197323483"},{"abbreviation":"Revise","comment":"*Revisions:*\nThe revisions on your first draft have significantly improved this second draft. You can continue to develop your writing by ✖.","id":"Revise0.9603588148548581"},{"abbreviation":"Strength","comment":"*Chief Strength:*\nThe chief strength of this writing is ✖. Use this as a model and do more of this throughout ✖.","id":"Strength0.662082616268034"},{"abbreviation":"Connects","comment":"*Connections:*\nYou make a strong connection between ✖ and ✖. Make more of these connections to improve your writing.","id":"Connects0.3393691896963966"},{"abbreviation":"Plan","comment":"*Planning:*\nYour writing shows a tremendous amount of careful planning. My key suggestion would be ✖.","id":"Plan0.6161424593054154"},{"abbreviation":"Research","comment":"*Research:*\nYou have spent a considerable amount of time and made the effort to research this topic thoroughly. One more suggestion would be to ✖.","id":"Research0.8263623830125415"},{"abbreviation":"Original","comment":"*Originality:*\nYour writing demonstrates a significant amount of original thought. To improve your final draft, focus on ✖.","id":"Original0.5821993179794982"},{"abbreviation":"Style","comment":"*Writing Style:*\nYour writing style is consistent and original. I would suggest ✖.","id":"Style0.7277357563357263"},{"abbreviation":"Content","comment":"*Content:*\nThe content and ideas presented throughout are impressive. Consider ✖.","id":"Content0.9114951817614971"},{"abbreviation":"Audience","comment":"*Audience:*\nYou have been especially considerate to your audience throughout your writing. Think about adding the following: ✖.","id":"Audience0.6676639290370772"},{"abbreviation":"Argument","comment":"*Argument:*\nYou have built a convincing argument throughout this essay to support your claim. To make your argument even more conclusive, try ✖.","id":"Argument0.9385949019276361"},{"abbreviation":"CntlIdea","comment":"*Controlling Idea:*\nYou have maintained the controlling idea of your thesis statement throughout this essay. What you need to do now is ✖.","id":"CntlIdea0.3876574307622429"},{"abbreviation":"Charact","comment":"*Characterization:*\nYour character development is creative and thorough in this story. However, ✖.","id":"Charact0.12358707787902046"},{"abbreviation":"Expos","comment":"*Exposition:*\nThe exposition (basic situation) is creatively established at the beginning of your story. To move the story along, you might consider ✖.","id":"Expos0.7977523434231149"},{"abbreviation":"PlotDev","comment":"*Plot Development:*\nYour plot development includes all the essential elements of effective story-telling. For additional revision, you might ✖.","id":"PlotDev0.7908738972269567"},{"abbreviation":"Dialg","comment":"*Dialogue:*\nYour use of dialogue is authentic, and you use a variety of speaker tags. You might ✖","id":"Dialg0.25169614242783767"},{"abbreviation":"Edit","comment":"*Edit and Complete Final Draft:*\nSpell check and ask others to edit by suggestion additions, deletions, corrections, and substitutions. Afterwards, complete your final edit, resolve the comments, click the \"Editing\" tab in the upper right corner of your Google doc and select the \"Viewing\" dropdown to re-read. If satisfied that this is your best work, share your document. I look forward to reading your final draft.","id":"Edit0.007788842499683479"}],"id":"End Comments0.5094690019691988"}],"setName":"middle"}